/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.query;

import android.os.Bundle;
import android.text.TextUtils;
import com.quickblox.auth.QBAuth;
import com.quickblox.core.QBCallback;
import com.quickblox.core.QBEntityCallback;
import com.quickblox.core.QBSettings;
import com.quickblox.core.exception.BaseServiceException;
import com.quickblox.core.exception.QBResponseException;
import com.quickblox.core.helper.Lo;
import com.quickblox.core.interfaces.QBCancelable;
import com.quickblox.core.parser.QBResponseParser;
import com.quickblox.core.rest.RestRequest;
import com.quickblox.core.rest.RestResponse;
import com.quickblox.core.result.Result;
import com.quickblox.core.server.BaseService;
import com.quickblox.core.server.Perform;
import com.quickblox.core.server.RestRequestCallback;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Query<T>
implements Perform<T>,
RestRequestCallback,
QBCancelable {
    private Bundle bundleResult = new Bundle();
    private QBCallback callback;
    private Object context;
    protected Type deserializer;
    protected QBEntityCallback<T> entityCallback;
    protected boolean isCancel = false;
    private Object originalObject;
    protected QBResponseParser<T> qbResponseParser;
    private QBSettings qbSettings = QBSettings.getInstance();
    private RestRequest restRequest;
    protected RestRequestCallback versionCallback;

    private void extractTokenExpirationDate(RestResponse object) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (object != null && (object = ((RestResponse)object).getHeaders()) != null && (object = (String)object.get("QB-Token-ExpirationDate")) != null) {
            try {
                object = simpleDateFormat.parse((String)object);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                object = null;
            }
            if (object != null) {
                try {
                    QBAuth.getBaseService().setTokenExpirationDate((Date)object);
                }
                catch (BaseServiceException baseServiceException) {
                    baseServiceException.printStackTrace();
                }
            }
        }
    }

    private void setApiVersion(RestRequest restRequest) {
        String string2 = this.qbSettings.getApiVersion();
        if (string2 != null) {
            restRequest.getHeaders().put("QuickBlox-REST-API-Version", string2);
        }
    }

    private void setFrameworkVersion(RestRequest restRequest) {
        String string2 = String.format("%s %s", "Android", this.qbSettings.getVersionName());
        restRequest.getHeaders().put("QB-SDK", string2);
    }

    protected String buildQueryUrl(Object ... object) {
        object = TextUtils.join((CharSequence)"/", (Object[])object);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BaseService.getServiceEndpointURL());
        stringBuilder.append("/");
        stringBuilder = new StringBuilder(stringBuilder.toString());
        stringBuilder.append((String)object);
        stringBuilder.append(".json");
        return stringBuilder.toString();
    }

    @Override
    public void cancel() {
        this.isCancel = true;
        this.restRequest.cancel();
        QBResponseParser<T> qBResponseParser = this.qbResponseParser;
        if (qBResponseParser != null) {
            qBResponseParser.cancel();
        }
    }

    @Override
    public void completedWithResponse(RestResponse restResponse) {
        Lo.g(restResponse);
        this.versionCallback.completedWithResponse(restResponse);
    }

    public Bundle getBundle() {
        return this.bundleResult;
    }

    public QBCallback getCallback() {
        return this.callback;
    }

    public Object getContext() {
        return this.context;
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    public QBResponseParser<T> getParser() {
        return this.qbResponseParser;
    }

    protected Class getResultClass() {
        return Result.class;
    }

    protected BaseService getService() {
        try {
            BaseService baseService = BaseService.getBaseService();
            return baseService;
        }
        catch (BaseServiceException baseServiceException) {
            baseServiceException.printStackTrace();
            return null;
        }
    }

    protected String getUrl() {
        return BaseService.getServiceEndpointURL();
    }

    protected void notifyErrors(List<String> list) {
        QBEntityCallback<T> qBEntityCallback = this.entityCallback;
        if (qBEntityCallback != null) {
            qBEntityCallback.onError(list);
        }
    }

    protected void notifySuccess(T t) {
        QBEntityCallback<T> qBEntityCallback = this.entityCallback;
        if (qBEntityCallback != null) {
            if (t != null) {
                qBEntityCallback.onSuccess(t, this.getBundle());
            } else {
                qBEntityCallback.onSuccess();
            }
        }
    }

    @Override
    public T perform(Bundle bundle) throws QBResponseException {
        Object object = new RestRequest();
        this.restRequest = object;
        this.setupRequest((RestRequest)object);
        Lo.g(this.restRequest);
        object = this.restRequest.syncRequest();
        if (((RestResponse)object).getStatusCode() > 0) {
            Lo.g(object);
        }
        this.extractTokenExpirationDate((RestResponse)object);
        return this.qbResponseParser.parse((RestResponse)object, bundle);
    }

    @Override
    public Query performAsyncWithCallback(QBCallback qBCallback) {
        this.performInBgAsyncWithDelegate(qBCallback);
        this.versionCallback = new VersionOldCallback();
        return this;
    }

    @Override
    public Query performAsyncWithCallback(QBCallback qBCallback, Object object) {
        this.context = object;
        this.performAsyncWithCallback(qBCallback);
        return this;
    }

    @Override
    public Query performAsyncWithCallback(QBEntityCallback<T> qBEntityCallback) {
        this.entityCallback = qBEntityCallback;
        this.performInBgAsyncWithDelegate(this.callback);
        this.versionCallback = new VersionEntityCallback();
        return this;
    }

    protected void performInBgAsyncWithDelegate(QBCallback object) {
        this.callback = object;
        this.restRequest = object = new RestRequest();
        this.setupRequest((RestRequest)object);
        Lo.g(this.restRequest);
        this.restRequest.asyncRequestWithCallback(this);
    }

    protected void putValue(Map<String, Object> map, String string2, Object object) {
        if (object != null) {
            map.put(string2, String.valueOf(object));
        }
    }

    protected void setAuthentication(RestRequest restRequest) {
        block3: {
            String string2 = BaseService.getBaseService().getToken();
            if (string2 == null) break block3;
            try {
                restRequest.getHeaders().put("QB-Token", string2);
            }
            catch (BaseServiceException baseServiceException) {
                baseServiceException.printStackTrace();
            }
        }
    }

    protected void setBody(RestRequest restRequest) {
    }

    public void setCallback(QBCallback qBCallback) {
        this.callback = qBCallback;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    protected void setFiles(RestRequest restRequest) {
    }

    protected void setHeaders(RestRequest restRequest) {
    }

    protected void setMethod(RestRequest restRequest) {
    }

    public void setOriginalObject(Object object) {
        this.originalObject = object;
    }

    protected void setParams(RestRequest restRequest) {
    }

    public void setParser(QBResponseParser qBResponseParser) {
        this.qbResponseParser = qBResponseParser;
    }

    protected void setShouldRedirect(RestRequest restRequest) {
    }

    protected void setUrl(RestRequest restRequest) {
        URL uRL;
        try {
            uRL = new URL(this.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            uRL = null;
        }
        restRequest.setUrl(uRL);
    }

    protected void setupRequest(RestRequest restRequest) {
        this.setBody(restRequest);
        this.setParams(restRequest);
        this.setHeaders(restRequest);
        this.setMethod(restRequest);
        this.setUrl(restRequest);
        this.setFiles(restRequest);
        this.setShouldRedirect(restRequest);
        this.setApiVersion(restRequest);
        this.setFrameworkVersion(restRequest);
        this.setAuthentication(restRequest);
    }

    private class VersionEntityCallback
    implements RestRequestCallback {
        private VersionEntityCallback() {
        }

        private QBResponseException createDefaultException() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Response parser was not specified");
            return new QBResponseException(arrayList);
        }

        @Override
        public void completedWithResponse(RestResponse object) {
            QBResponseParser qBResponseParser;
            block7: {
                if (Query.this.isCancel) {
                    return;
                }
                Query.this.extractTokenExpirationDate((RestResponse)object);
                QBResponseParser qBResponseParser2 = Query.this.qbResponseParser;
                qBResponseParser = null;
                if (qBResponseParser2 != null) {
                    try {
                        qBResponseParser2 = Query.this.qbResponseParser.parse((RestResponse)object, Query.this.getBundle());
                        object = qBResponseParser;
                        qBResponseParser = qBResponseParser2;
                    }
                    catch (QBResponseException qBResponseException) {
                        break block7;
                    }
                }
                object = this.createDefaultException();
            }
            qBResponseParser = null;
            if (Query.this.isCancel) {
                return;
            }
            if (object == null) {
                Query.this.notifySuccess(qBResponseParser);
            } else {
                Query.this.notifyErrors(((QBResponseException)object).getErrors());
            }
        }
    }

    private class VersionOldCallback
    implements RestRequestCallback {
        private VersionOldCallback() {
        }

        @Override
        public void completedWithResponse(RestResponse restResponse) {
            if (Query.this.isCancel) {
                return;
            }
            Result result = new Result();
            try {
                Result result2;
                result = result2 = (Result)Query.this.getResultClass().newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            result.setQuery(Query.this);
            result.setResponse(restResponse);
            Query.this.extractTokenExpirationDate(restResponse);
            if (Query.this.isCancel) {
                return;
            }
            this.notifyCallback(result);
        }

        protected void notifyCallback(Result result) {
            if (Query.this.callback != null) {
                if (Query.this.context != null) {
                    Query.this.callback.onComplete(result, Query.this.context);
                } else {
                    Query.this.callback.onComplete(result);
                }
            }
        }
    }
}

