/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.request;

import com.quickblox.core.QBProgressCallback;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class ProgressHttpEntityWrapper
extends HttpEntityWrapper {
    private final QBProgressCallback progressCallback;

    public ProgressHttpEntityWrapper(HttpEntity httpEntity, QBProgressCallback qBProgressCallback) {
        super(httpEntity);
        this.progressCallback = qBProgressCallback;
    }

    public InputStream getContent() throws IOException {
        return new ProgressFilterInputStream(this.wrappedEntity.getContent(), this.progressCallback, this.getContentLength());
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        HttpEntity httpEntity = this.wrappedEntity;
        if (!(outputStream instanceof ProgressFilterOutputStream)) {
            outputStream = new ProgressFilterOutputStream(outputStream, this.progressCallback, this.getContentLength());
        }
        httpEntity.writeTo(outputStream);
    }

    static class ProgressFilterInputStream
    extends FilterInputStream {
        private QBProgressCallback progressCallback;
        private long received;
        private long totalBytes;

        ProgressFilterInputStream(InputStream inputStream, QBProgressCallback qBProgressCallback, long l) {
            super(inputStream);
            this.progressCallback = qBProgressCallback;
            this.received = 0L;
            this.totalBytes = l;
        }

        private int getCurrentProgress() {
            return (int)(this.received * 100L / this.totalBytes);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n = this.in.read(byArray);
            this.received += (long)n;
            this.progressCallback.onProgressUpdate(this.getCurrentProgress());
            if ((float)this.getCurrentProgress() == 100.0f) {
                n = -1;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            n = this.in.read(byArray, n, n2);
            this.received += (long)n2;
            this.progressCallback.onProgressUpdate(this.getCurrentProgress());
            if ((float)this.getCurrentProgress() == 100.0f) {
                n = -1;
            }
            return n;
        }
    }

    static class ProgressFilterOutputStream
    extends FilterOutputStream {
        private QBProgressCallback progressCallback;
        private long totalBytes;
        private long transferred;

        ProgressFilterOutputStream(OutputStream outputStream, QBProgressCallback qBProgressCallback, long l) {
            super(outputStream);
            this.progressCallback = qBProgressCallback;
            this.transferred = 0L;
            this.totalBytes = l;
        }

        private int getCurrentProgress() {
            return (int)(this.transferred * 100L / this.totalBytes);
        }

        private void validateProgress() {
            if ((float)this.transferred == 100.0f) {
                this.progressCallback = null;
            } else {
                this.progressCallback.onProgressUpdate(this.getCurrentProgress());
            }
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.transferred;
            this.progressCallback.onProgressUpdate(this.getCurrentProgress());
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.transferred += (long)n2;
            this.progressCallback.onProgressUpdate(this.getCurrentProgress());
        }
    }
}

