/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.result;

import com.quickblox.core.parser.QBJsonErrorParser;
import com.quickblox.core.query.Query;
import com.quickblox.core.rest.RestResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestResult {
    private static Map<Integer, String> errorMsgs;
    private List<String> errors = new ArrayList<String>();
    private Query query;
    protected RestResponse response;

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        errorMsgs = hashMap;
        hashMap.put(404, "Entity you are looking for was not found.");
        errorMsgs.put(500, "We're sorry, but something went wrong. We've been notified about this issue and we'll take a look at it shortly.");
    }

    public RestResult() {
        this.errors = new ArrayList<String>();
    }

    public RestResult(RestResponse restResponse) {
        this.response = restResponse;
    }

    private void checkServerError(int n) {
        String string2 = errorMsgs.get(n);
        if (string2 != null) {
            this.errors.add(string2);
        }
    }

    private boolean isXml() {
        if (!this.isEmpty()) {
            return this.getRawBody().startsWith("<?xml");
        }
        return false;
    }

    protected void extractEntity() {
    }

    public List<String> getErrors() {
        return this.errors;
    }

    protected Query getQuery() {
        return this.query;
    }

    public String getRawBody() {
        RestResponse restResponse = this.response;
        if (restResponse != null) {
            return restResponse.getRawBody();
        }
        return "";
    }

    protected RestResponse getResponse() {
        return this.response;
    }

    public int getStatusCode() {
        RestResponse restResponse = this.response;
        if (restResponse != null) {
            return restResponse.getStatusCode();
        }
        return 0;
    }

    public boolean isArray() {
        boolean bl;
        boolean bl2 = this.isEmpty();
        boolean bl3 = bl = false;
        if (!bl2) {
            bl3 = bl;
            if (this.getRawBody().charAt(0) == '[') {
                bl3 = true;
            }
        }
        return bl3;
    }

    protected boolean isEmpty() {
        boolean bl;
        String string2 = this.getRawBody();
        boolean bl2 = bl = true;
        if (string2 != null) {
            bl2 = this.getRawBody().trim().length() == 0 ? bl : false;
        }
        return bl2;
    }

    boolean isObject() {
        boolean bl;
        boolean bl2 = this.isEmpty();
        boolean bl3 = bl = false;
        if (!bl2) {
            bl3 = bl;
            if (this.getRawBody().charAt(0) == '{') {
                bl3 = true;
            }
        }
        return bl3;
    }

    protected boolean notFoundError() {
        boolean bl;
        RestResponse restResponse = this.response;
        boolean bl2 = bl = false;
        if (restResponse != null) {
            int n = this.getStatusCode();
            bl2 = bl;
            if (n != 200) {
                bl2 = bl;
                if (n != 201) {
                    bl2 = bl;
                    if (n != 202) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    protected void processResponse() {
        String string2 = this.getRawBody();
        if (!(this.isEmpty() || this.isArray() || this.isXml())) {
            new QBJsonErrorParser(this.errors).parseError(string2);
        }
    }

    public void setErrors(List<String> list) {
        this.errors = list;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setResponse(RestResponse restResponse) {
        this.response = restResponse;
        if (restResponse != null) {
            if (restResponse.getIOException() != null) {
                this.errors.add("Connection failed. Please check your internet connection.");
            } else {
                this.checkServerError(restResponse.getStatusCode());
            }
            this.processResponse();
        } else {
            this.errors.add("Connection closed due to timeout. Please check your internet connection.");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RestResult{isEmpty=");
        stringBuilder.append(this.isEmpty());
        stringBuilder.append(", notFoundError=");
        stringBuilder.append(this.notFoundError());
        stringBuilder.append(", statusCode=");
        stringBuilder.append(this.getStatusCode());
        stringBuilder.append(", onError=");
        stringBuilder.append(this.getStatusCode());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

