/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.server;

import com.quickblox.core.QBProgressCallback;
import com.quickblox.core.request.ProgressHttpEntityWrapper;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpExecutor {
    public static HttpClient httpClient;

    public static HttpResponse execute(HttpRequestBase httpRequestBase) throws IOException {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        httpClient = defaultHttpClient;
        return defaultHttpClient.execute((HttpUriRequest)httpRequestBase);
    }

    public static HttpResponse execute(HttpRequestBase httpRequestBase, QBProgressCallback qBProgressCallback) throws IOException {
        httpClient = new DefaultHttpClient();
        if (httpRequestBase instanceof HttpGet && HttpExecutor.isProgresCallbackRequired(httpRequestBase)) {
            HttpExecutor.removeCallbackHeader(httpRequestBase);
            httpRequestBase = httpClient.execute((HttpUriRequest)httpRequestBase);
            httpRequestBase.setEntity((HttpEntity)new ProgressHttpEntityWrapper(httpRequestBase.getEntity(), qBProgressCallback));
            return httpRequestBase;
        }
        return httpClient.execute((HttpUriRequest)httpRequestBase);
    }

    private static boolean isProgresCallbackRequired(HttpRequestBase httpRequestBase) {
        Header[] headerArray = httpRequestBase.getAllHeaders();
        int n = headerArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            httpRequestBase = headerArray[i];
            if (!httpRequestBase.getName().equals("progress_callback_enabled")) continue;
            bl = httpRequestBase.getValue().equals("enabled");
        }
        return bl;
    }

    private static void removeCallbackHeader(HttpRequestBase httpRequestBase) {
        for (Header header : httpRequestBase.getAllHeaders()) {
            if (!header.getName().equals("progress_callback_enabled")) continue;
            httpRequestBase.removeHeader(header);
        }
    }
}

