/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.users.query;

import com.quickblox.core.RestMethod;
import com.quickblox.core.helper.StringifyArrayList;
import com.quickblox.core.parser.QBJsonParser;
import com.quickblox.core.query.JsonQuery;
import com.quickblox.core.rest.RestRequest;
import com.quickblox.users.deserializer.QBStringifyArrayListDeserializer;
import com.quickblox.users.model.QBUser;
import com.quickblox.users.model.QBUserWrap;
import com.quickblox.users.result.QBUserResult;
import java.lang.reflect.Type;

public class QueryGetUser
extends JsonQuery<QBUser> {
    public static final int BY_EMAIL = 1;
    public static final int BY_EXTERNAL_USER_ID = 4;
    public static final int BY_FACEBOOK_ID = 2;
    public static final int BY_LOGIN = 0;
    public static final int BY_TWITTER_ID = 3;
    private static String[] filters = new String[]{"login", "email", "facebook_id", "twitter_id", "external"};
    private Integer filterType;
    private QBUser user;

    public QueryGetUser(QBUser qBUser) {
        ((QBJsonParser)this.getParser()).initParser((Type)((Object)QBUserWrap.class), (Type)((Object)StringifyArrayList.class), new QBStringifyArrayListDeserializer());
        this.user = qBUser;
        this.setOriginalObject(qBUser);
    }

    public QueryGetUser(QBUser qBUser, int n) {
        this(qBUser);
        this.filterType = n;
    }

    @Override
    public Class getResultClass() {
        return QBUserResult.class;
    }

    @Override
    protected String getUrl() {
        Comparable<Integer> comparable = this.filterType;
        if (comparable != null) {
            if ((Integer)comparable != 4) {
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append("by_");
                ((StringBuilder)comparable).append(filters[this.filterType]);
                return this.buildQueryUrl("users", ((StringBuilder)comparable).toString());
            }
            return this.buildQueryUrl("users", "external", this.user.getExternalId());
        }
        return this.buildQueryUrl("users", this.user.getId());
    }

    @Override
    protected void setMethod(RestRequest restRequest) {
        restRequest.setMethod(RestMethod.GET);
    }

    @Override
    protected void setParams(RestRequest restRequest) {
        Object object = this.filterType;
        if (object != null && (Integer)object != 4) {
            int n = this.filterType;
            object = n != 0 ? (n != 1 ? (n != 2 ? (n != 3 ? null : this.user.getTwitterId().toString()) : this.user.getFacebookId().toString()) : this.user.getEmail()) : this.user.getLogin();
            this.putValue(restRequest.getParameters(), filters[this.filterType], object);
        }
    }
}

