/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;

public class Angle {
    public static final int CLOCKWISE = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int NONE = 0;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final double PI_TIMES_2 = Math.PI * 2;

    public static double angle(Coordinate coordinate) {
        return Math.atan2(coordinate.y, coordinate.x);
    }

    public static double angle(Coordinate coordinate, Coordinate coordinate2) {
        double d = coordinate2.x;
        double d2 = coordinate.x;
        return Math.atan2(coordinate2.y - coordinate.y, d - d2);
    }

    public static double angleBetween(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return Angle.diff(Angle.angle(coordinate2, coordinate), Angle.angle(coordinate2, coordinate3));
    }

    public static double angleBetweenOriented(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Angle.angle(coordinate2, coordinate);
        double d2 = Angle.angle(coordinate2, coordinate3) - d;
        if (d2 <= -Math.PI) {
            return d2 + Math.PI * 2;
        }
        d = d2;
        if (d2 > Math.PI) {
            d = d2 - Math.PI * 2;
        }
        return d;
    }

    public static double diff(double d, double d2) {
        d = d < d2 ? d2 - d : (d -= d2);
        d2 = d;
        if (d > Math.PI) {
            d2 = Math.PI * 2 - d;
        }
        return d2;
    }

    public static int getTurn(double d, double d2) {
        if ((d = Math.sin(d2 - d)) > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double interiorAngle(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Angle.angle(coordinate2, coordinate);
        return Math.abs(Angle.angle(coordinate2, coordinate3) - d);
    }

    public static boolean isAcute(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate.x;
        double d2 = coordinate2.x;
        double d3 = coordinate.y;
        double d4 = coordinate2.y;
        return (d - d2) * (coordinate3.x - coordinate2.x) + (d3 - d4) * (coordinate3.y - coordinate2.y) > 0.0;
    }

    public static boolean isObtuse(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate.x;
        double d2 = coordinate2.x;
        double d3 = coordinate.y;
        double d4 = coordinate2.y;
        return (d - d2) * (coordinate3.x - coordinate2.x) + (d3 - d4) * (coordinate3.y - coordinate2.y) < 0.0;
    }

    public static double normalize(double d) {
        while (true) {
            if (!(d > Math.PI)) {
                while (true) {
                    if (!(d <= -Math.PI)) {
                        return d;
                    }
                    d += Math.PI * 2;
                }
            }
            d -= Math.PI * 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double normalizePositive(double d) {
        double d2 = 0.0;
        double d3 = d;
        if (d < 0.0) {
            d3 = d;
            while (true) {
                if (!(d3 < 0.0)) {
                    d = d3;
                    if (!(d3 >= Math.PI * 2)) return d;
                    return d2;
                }
                d3 += Math.PI * 2;
            }
        }
        while (true) {
            if (!(d3 >= Math.PI * 2)) {
                d = d3;
                if (!(d3 < 0.0)) return d;
                return d2;
            }
            d3 -= Math.PI * 2;
        }
    }

    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double toRadians(double d) {
        return d * Math.PI / 180.0;
    }
}

