/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

public interface BoundaryNodeRule {
    public static final BoundaryNodeRule ENDPOINT_BOUNDARY_RULE;
    public static final BoundaryNodeRule MOD2_BOUNDARY_RULE;
    public static final BoundaryNodeRule MONOVALENT_ENDPOINT_BOUNDARY_RULE;
    public static final BoundaryNodeRule MULTIVALENT_ENDPOINT_BOUNDARY_RULE;
    public static final BoundaryNodeRule OGC_SFS_BOUNDARY_RULE;

    static {
        Mod2BoundaryNodeRule mod2BoundaryNodeRule = new Mod2BoundaryNodeRule();
        MOD2_BOUNDARY_RULE = mod2BoundaryNodeRule;
        ENDPOINT_BOUNDARY_RULE = new EndPointBoundaryNodeRule();
        MULTIVALENT_ENDPOINT_BOUNDARY_RULE = new MultiValentEndPointBoundaryNodeRule();
        MONOVALENT_ENDPOINT_BOUNDARY_RULE = new MonoValentEndPointBoundaryNodeRule();
        OGC_SFS_BOUNDARY_RULE = mod2BoundaryNodeRule;
    }

    public boolean isInBoundary(int var1);

    public static class EndPointBoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int n) {
            return n > 0;
        }
    }

    public static class Mod2BoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int n) {
            return n % 2 == 1;
        }
    }

    public static class MonoValentEndPointBoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int n) {
            return n == 1;
        }
    }

    public static class MultiValentEndPointBoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int n) {
            return n > 1;
        }
    }
}

