/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.math.Vector3D;

public class CGAlgorithms3D {
    public static double distance(Coordinate coordinate, Coordinate coordinate2) {
        if (!Double.isNaN(coordinate.z) && !Double.isNaN(coordinate2.z)) {
            double d = coordinate.x - coordinate2.x;
            double d2 = coordinate.y - coordinate2.y;
            double d3 = coordinate.z - coordinate2.z;
            return Math.sqrt(d * d + d2 * d2 + d3 * d3);
        }
        return coordinate.distance(coordinate2);
    }

    public static double distancePointSegment(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (coordinate2.equals3D(coordinate3)) {
            return CGAlgorithms3D.distance(coordinate, coordinate2);
        }
        double d = (coordinate3.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate3.y - coordinate2.y) * (coordinate3.y - coordinate2.y) + (coordinate3.z - coordinate2.z) * (coordinate3.z - coordinate2.z);
        if (!Double.isNaN(d)) {
            double d2 = ((coordinate.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate.y - coordinate2.y) * (coordinate3.y - coordinate2.y) + (coordinate.z - coordinate2.z) * (coordinate3.z - coordinate2.z)) / d;
            if (d2 <= 0.0) {
                return CGAlgorithms3D.distance(coordinate, coordinate2);
            }
            if (d2 >= 1.0) {
                return CGAlgorithms3D.distance(coordinate, coordinate3);
            }
            double d3 = coordinate2.x;
            double d4 = coordinate3.x;
            double d5 = coordinate2.x;
            double d6 = coordinate2.y;
            double d7 = coordinate3.y;
            double d8 = coordinate2.y;
            d = coordinate2.z;
            double d9 = coordinate3.z;
            double d10 = coordinate2.z;
            d4 = coordinate.x - (d3 + (d4 - d5) * d2);
            d7 = coordinate.y - (d6 + (d7 - d8) * d2);
            d = coordinate.z - (d + d2 * (d9 - d10));
            return Math.sqrt(d4 * d4 + d7 * d7 + d * d);
        }
        throw new IllegalArgumentException("Ordinates must not be NaN");
    }

    public static double distanceSegmentSegment(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        if (coordinate.equals3D(coordinate2)) {
            return CGAlgorithms3D.distancePointSegment(coordinate, coordinate3, coordinate4);
        }
        if (coordinate3.equals3D(coordinate2)) {
            return CGAlgorithms3D.distancePointSegment(coordinate3, coordinate, coordinate2);
        }
        double d = Vector3D.dot(coordinate, coordinate2, coordinate, coordinate2);
        double d2 = Vector3D.dot(coordinate, coordinate2, coordinate3, coordinate4);
        double d3 = Vector3D.dot(coordinate3, coordinate4, coordinate3, coordinate4);
        double d4 = Vector3D.dot(coordinate, coordinate2, coordinate3, coordinate);
        double d5 = Vector3D.dot(coordinate3, coordinate4, coordinate3, coordinate);
        double d6 = d * d3 - d2 * d2;
        if (!Double.isNaN(d6)) {
            if (d6 <= 0.0) {
                d5 = d2 > d3 ? d4 / d2 : (d5 /= d3);
                d3 = 0.0;
            } else {
                d3 = (d2 * d5 - d3 * d4) / d6;
                d5 = (d * d5 - d2 * d4) / d6;
            }
            if (d3 < 0.0) {
                return CGAlgorithms3D.distancePointSegment(coordinate, coordinate3, coordinate4);
            }
            if (d3 > 1.0) {
                return CGAlgorithms3D.distancePointSegment(coordinate2, coordinate3, coordinate4);
            }
            if (d5 < 0.0) {
                return CGAlgorithms3D.distancePointSegment(coordinate3, coordinate, coordinate2);
            }
            if (d5 > 1.0) {
                return CGAlgorithms3D.distancePointSegment(coordinate4, coordinate, coordinate2);
            }
            d = coordinate.x;
            double d7 = coordinate2.x;
            double d8 = coordinate.x;
            double d9 = coordinate.y;
            d4 = coordinate2.y;
            double d10 = coordinate.y;
            double d11 = coordinate.z;
            double d12 = coordinate2.z;
            d6 = coordinate.z;
            double d13 = coordinate3.x;
            double d14 = coordinate4.x;
            double d15 = coordinate3.x;
            d2 = coordinate3.y;
            double d16 = coordinate4.y;
            double d17 = coordinate3.y;
            double d18 = coordinate3.z;
            double d19 = coordinate4.z;
            double d20 = coordinate3.z;
            return CGAlgorithms3D.distance(new Coordinate(d + (d7 - d8) * d3, d9 + (d4 - d10) * d3, d11 + d3 * (d12 - d6)), new Coordinate(d13 + (d14 - d15) * d5, d2 + (d16 - d17) * d5, d18 + d5 * (d19 - d20)));
        }
        throw new IllegalArgumentException("Ordinates must not be NaN");
    }
}

