/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;

public class CentralEndpointIntersector {
    private Coordinate intPt = null;
    private double minDist = Double.MAX_VALUE;
    private Coordinate[] pts;

    public CentralEndpointIntersector(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        this.pts = new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4};
        this.compute();
    }

    private void Ocompute() {
        this.intPt = new Coordinate(this.findNearestPoint(CentralEndpointIntersector.average(this.pts), this.pts));
    }

    private static Coordinate average(Coordinate[] coordinateArray) {
        Coordinate coordinate = new Coordinate();
        int n = coordinateArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= coordinateArray.length) {
                if (n > 0) {
                    double d = coordinate.x;
                    double d2 = n;
                    coordinate.x = d / d2;
                    coordinate.y /= d2;
                }
                return coordinate;
            }
            coordinate.x += coordinateArray[n2].x;
            coordinate.y += coordinateArray[n2].y;
            ++n2;
        }
    }

    private void compute() {
        Coordinate[] coordinateArray = this.pts;
        this.tryDist(coordinateArray[0], coordinateArray[2], coordinateArray[3]);
        coordinateArray = this.pts;
        this.tryDist(coordinateArray[1], coordinateArray[2], coordinateArray[3]);
        coordinateArray = this.pts;
        this.tryDist(coordinateArray[2], coordinateArray[0], coordinateArray[1]);
        coordinateArray = this.pts;
        this.tryDist(coordinateArray[3], coordinateArray[0], coordinateArray[1]);
    }

    private Coordinate findNearestPoint(Coordinate coordinate, Coordinate[] coordinateArray) {
        double d = Double.MAX_VALUE;
        Coordinate coordinate2 = null;
        int n = 0;
        while (true) {
            double d2;
            block6: {
                double d3;
                block5: {
                    if (n >= coordinateArray.length) {
                        return coordinate2;
                    }
                    d3 = coordinate.distance(coordinateArray[n]);
                    if (n == 0) break block5;
                    d2 = d;
                    if (!(d3 < d)) break block6;
                }
                coordinate2 = coordinateArray[n];
                d2 = d3;
            }
            ++n;
            d = d2;
        }
    }

    public static Coordinate getIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        return new CentralEndpointIntersector(coordinate, coordinate2, coordinate3, coordinate4).getIntersection();
    }

    private void tryDist(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = CGAlgorithms.distancePointLine(coordinate, coordinate2, coordinate3);
        if (d < this.minDist) {
            this.minDist = d;
            this.intPt = coordinate;
        }
    }

    public Coordinate getIntersection() {
        return this.intPt;
    }
}

