/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class Centroid {
    private Coordinate areaBasePt = null;
    private double areasum2 = 0.0;
    private Coordinate cg3;
    private Coordinate lineCentSum;
    private Coordinate ptCentSum;
    private int ptCount = 0;
    private double totalLength = 0.0;
    private Coordinate triangleCent3 = new Coordinate();

    public Centroid(Geometry geometry) {
        this.cg3 = new Coordinate();
        this.lineCentSum = new Coordinate();
        this.ptCentSum = new Coordinate();
        this.add(geometry);
    }

    private void add(Geometry geometry) {
        if (geometry.isEmpty()) {
            return;
        }
        if (geometry instanceof Point) {
            this.addPoint(geometry.getCoordinate());
        } else if (geometry instanceof LineString) {
            this.addLineSegments(geometry.getCoordinates());
        } else if (geometry instanceof Polygon) {
            this.add((Polygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            geometry = (GeometryCollection)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                this.add(((GeometryCollection)geometry).getGeometryN(i));
            }
        }
    }

    private void add(Polygon polygon) {
        this.addShell(polygon.getExteriorRing().getCoordinates());
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.addHole(polygon.getInteriorRingN(n).getCoordinates());
            ++n;
        }
        return;
    }

    private void addHole(Coordinate[] coordinateArray) {
        boolean bl = CGAlgorithms.isCCW(coordinateArray);
        int n = 0;
        while (true) {
            if (n >= coordinateArray.length - 1) {
                this.addLineSegments(coordinateArray);
                return;
            }
            Coordinate coordinate = this.areaBasePt;
            Coordinate coordinate2 = coordinateArray[n];
            this.addTriangle(coordinate, coordinate2, coordinateArray[++n], bl);
        }
    }

    private void addLineSegments(Coordinate[] coordinateArray) {
        double d = 0.0;
        int n = 0;
        while (true) {
            if (n >= coordinateArray.length - 1) {
                this.totalLength += d;
                if (d == 0.0 && coordinateArray.length > 0) {
                    this.addPoint(coordinateArray[0]);
                }
                return;
            }
            Coordinate coordinate = coordinateArray[n];
            int n2 = n + 1;
            double d2 = coordinate.distance(coordinateArray[n2]);
            if (d2 != 0.0) {
                d += d2;
                double d3 = (coordinateArray[n].x + coordinateArray[n2].x) / 2.0;
                coordinate = this.lineCentSum;
                coordinate.x += d3 * d2;
                d3 = (coordinateArray[n].y + coordinateArray[n2].y) / 2.0;
                coordinate = this.lineCentSum;
                coordinate.y += d2 * d3;
            }
            n = n2;
        }
    }

    private void addPoint(Coordinate coordinate) {
        ++this.ptCount;
        Coordinate coordinate2 = this.ptCentSum;
        coordinate2.x += coordinate.x;
        coordinate2 = this.ptCentSum;
        coordinate2.y += coordinate.y;
    }

    private void addShell(Coordinate[] coordinateArray) {
        int n = coordinateArray.length;
        int n2 = 0;
        if (n > 0) {
            this.setBasePoint(coordinateArray[0]);
        }
        boolean bl = CGAlgorithms.isCCW(coordinateArray);
        while (true) {
            if (n2 >= coordinateArray.length - 1) {
                this.addLineSegments(coordinateArray);
                return;
            }
            Coordinate coordinate = this.areaBasePt;
            Coordinate coordinate2 = coordinateArray[n2];
            this.addTriangle(coordinate, coordinate2, coordinateArray[++n2], bl ^ true);
        }
    }

    private void addTriangle(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, boolean bl) {
        double d = bl ? 1.0 : -1.0;
        Centroid.centroid3(coordinate, coordinate2, coordinate3, this.triangleCent3);
        double d2 = Centroid.area2(coordinate, coordinate2, coordinate3);
        coordinate = this.cg3;
        double d3 = coordinate.x;
        coordinate.x = d3 + this.triangleCent3.x * (d *= d2);
        coordinate = this.cg3;
        coordinate.y += this.triangleCent3.y * d;
        this.areasum2 += d;
    }

    private static double area2(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate.y) - (coordinate3.x - coordinate.x) * (coordinate2.y - coordinate.y);
    }

    private static void centroid3(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        coordinate4.x = coordinate.x + coordinate2.x + coordinate3.x;
        coordinate4.y = coordinate.y + coordinate2.y + coordinate3.y;
    }

    public static Coordinate getCentroid(Geometry geometry) {
        return new Centroid(geometry).getCentroid();
    }

    private void setBasePoint(Coordinate coordinate) {
        if (this.areaBasePt == null) {
            this.areaBasePt = coordinate;
        }
    }

    public Coordinate getCentroid() {
        block5: {
            Coordinate coordinate;
            block3: {
                block4: {
                    block2: {
                        coordinate = new Coordinate();
                        if (!(Math.abs(this.areasum2) > 0.0)) break block2;
                        coordinate.x = this.cg3.x / 3.0 / this.areasum2;
                        coordinate.y = this.cg3.y / 3.0 / this.areasum2;
                        break block3;
                    }
                    if (!(this.totalLength > 0.0)) break block4;
                    coordinate.x = this.lineCentSum.x / this.totalLength;
                    coordinate.y = this.lineCentSum.y / this.totalLength;
                    break block3;
                }
                if (this.ptCount <= 0) break block5;
                coordinate.x = this.ptCentSum.x / (double)this.ptCount;
                coordinate.y = this.ptCentSum.y / (double)this.ptCount;
            }
            return coordinate;
        }
        return null;
    }
}

