/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;

public class CentroidArea {
    private double areasum2 = 0.0;
    private Coordinate basePt = null;
    private Coordinate centSum;
    private Coordinate cg3;
    private double totalLength = 0.0;
    private Coordinate triangleCent3 = new Coordinate();

    public CentroidArea() {
        this.cg3 = new Coordinate();
        this.centSum = new Coordinate();
    }

    private void add(Polygon polygon) {
        this.addShell(polygon.getExteriorRing().getCoordinates());
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.addHole(polygon.getInteriorRingN(n).getCoordinates());
            ++n;
        }
        return;
    }

    private void addHole(Coordinate[] coordinateArray) {
        boolean bl = CGAlgorithms.isCCW(coordinateArray);
        int n = 0;
        while (true) {
            if (n >= coordinateArray.length - 1) {
                this.addLinearSegments(coordinateArray);
                return;
            }
            Coordinate coordinate = this.basePt;
            Coordinate coordinate2 = coordinateArray[n];
            this.addTriangle(coordinate, coordinate2, coordinateArray[++n], bl);
        }
    }

    private void addLinearSegments(Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length - 1) {
            Coordinate coordinate = coordinateArray[n];
            int n2 = n + 1;
            double d = coordinate.distance(coordinateArray[n2]);
            this.totalLength += d;
            double d2 = (coordinateArray[n].x + coordinateArray[n2].x) / 2.0;
            coordinate = this.centSum;
            coordinate.x += d2 * d;
            d2 = (coordinateArray[n].y + coordinateArray[n2].y) / 2.0;
            coordinate = this.centSum;
            coordinate.y += d * d2;
            n = n2;
        }
        return;
    }

    private void addShell(Coordinate[] coordinateArray) {
        boolean bl = CGAlgorithms.isCCW(coordinateArray);
        int n = 0;
        while (true) {
            if (n >= coordinateArray.length - 1) {
                this.addLinearSegments(coordinateArray);
                return;
            }
            Coordinate coordinate = this.basePt;
            Coordinate coordinate2 = coordinateArray[n];
            this.addTriangle(coordinate, coordinate2, coordinateArray[++n], bl ^ true);
        }
    }

    private void addTriangle(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, boolean bl) {
        double d = bl ? 1.0 : -1.0;
        CentroidArea.centroid3(coordinate, coordinate2, coordinate3, this.triangleCent3);
        double d2 = CentroidArea.area2(coordinate, coordinate2, coordinate3);
        coordinate = this.cg3;
        double d3 = coordinate.x;
        coordinate.x = d3 + this.triangleCent3.x * (d *= d2);
        coordinate = this.cg3;
        coordinate.y += this.triangleCent3.y * d;
        this.areasum2 += d;
    }

    private static double area2(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate.y) - (coordinate3.x - coordinate.x) * (coordinate2.y - coordinate.y);
    }

    private static void centroid3(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        coordinate4.x = coordinate.x + coordinate2.x + coordinate3.x;
        coordinate4.y = coordinate.y + coordinate2.y + coordinate3.y;
    }

    private void setBasePoint(Coordinate coordinate) {
        if (this.basePt == null) {
            this.basePt = coordinate;
        }
    }

    public void add(Geometry geometry) {
        boolean bl = geometry instanceof Polygon;
        if (bl) {
            geometry = (Polygon)geometry;
            this.setBasePoint(((Polygon)geometry).getExteriorRing().getCoordinateN(0));
            this.add((Polygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            geometry = (GeometryCollection)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                this.add(((GeometryCollection)geometry).getGeometryN(i));
            }
        }
    }

    public void add(Coordinate[] coordinateArray) {
        this.setBasePoint(coordinateArray[0]);
        this.addShell(coordinateArray);
    }

    public Coordinate getCentroid() {
        Coordinate coordinate = new Coordinate();
        if (Math.abs(this.areasum2) > 0.0) {
            coordinate.x = this.cg3.x / 3.0 / this.areasum2;
            coordinate.y = this.cg3.y / 3.0 / this.areasum2;
        } else {
            coordinate.x = this.centSum.x / this.totalLength;
            coordinate.y = this.centSum.y / this.totalLength;
        }
        return coordinate;
    }
}

