/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.UniqueCoordinateArrayFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.TreeSet;

public class ConvexHull {
    private GeometryFactory geomFactory;
    private Coordinate[] inputPts;

    public ConvexHull(Geometry geometry) {
        this(ConvexHull.extractCoordinates(geometry), geometry.getFactory());
    }

    public ConvexHull(Coordinate[] coordinateArray, GeometryFactory geometryFactory) {
        this.inputPts = UniqueCoordinateArrayFilter.filterCoordinates(coordinateArray);
        this.geomFactory = geometryFactory;
    }

    private Coordinate[] cleanRing(Coordinate[] coordinateArray) {
        int n = 0;
        Assert.equals(coordinateArray[0], coordinateArray[coordinateArray.length - 1]);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        Coordinate coordinate = null;
        while (true) {
            Coordinate coordinate2;
            if (n > coordinateArray.length - 2) {
                arrayList.add(coordinateArray[coordinateArray.length - 1]);
                return arrayList.toArray(new Coordinate[arrayList.size()]);
            }
            Coordinate coordinate3 = coordinateArray[n];
            if (coordinate3.equals(coordinate2 = coordinateArray[++n]) || coordinate != null && this.isBetween(coordinate, coordinate3, coordinate2)) continue;
            arrayList.add(coordinate3);
            coordinate = coordinate3;
        }
    }

    private Coordinate[] computeOctPts(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = new Coordinate[8];
        int n = 0;
        while (true) {
            if (n >= 8) {
                n = 1;
                while (true) {
                    if (n >= coordinateArray.length) {
                        return coordinateArray2;
                    }
                    if (coordinateArray[n].x < coordinateArray2[0].x) {
                        coordinateArray2[0] = coordinateArray[n];
                    }
                    if (coordinateArray[n].x - coordinateArray[n].y < coordinateArray2[1].x - coordinateArray2[1].y) {
                        coordinateArray2[1] = coordinateArray[n];
                    }
                    if (coordinateArray[n].y > coordinateArray2[2].y) {
                        coordinateArray2[2] = coordinateArray[n];
                    }
                    if (coordinateArray[n].x + coordinateArray[n].y > coordinateArray2[3].x + coordinateArray2[3].y) {
                        coordinateArray2[3] = coordinateArray[n];
                    }
                    if (coordinateArray[n].x > coordinateArray2[4].x) {
                        coordinateArray2[4] = coordinateArray[n];
                    }
                    if (coordinateArray[n].x - coordinateArray[n].y > coordinateArray2[5].x - coordinateArray2[5].y) {
                        coordinateArray2[5] = coordinateArray[n];
                    }
                    if (coordinateArray[n].y < coordinateArray2[6].y) {
                        coordinateArray2[6] = coordinateArray[n];
                    }
                    if (coordinateArray[n].x + coordinateArray[n].y < coordinateArray2[7].x + coordinateArray2[7].y) {
                        coordinateArray2[7] = coordinateArray[n];
                    }
                    ++n;
                }
            }
            coordinateArray2[n] = coordinateArray[0];
            ++n;
        }
    }

    private Coordinate[] computeOctRing(Coordinate[] object) {
        Coordinate[] coordinateArray = this.computeOctPts((Coordinate[])object);
        object = new CoordinateList();
        ((CoordinateList)object).add(coordinateArray, false);
        if (((ArrayList)object).size() < 3) {
            return null;
        }
        ((CoordinateList)object).closeRing();
        return ((CoordinateList)object).toCoordinateArray();
    }

    private static Coordinate[] extractCoordinates(Geometry geometry) {
        UniqueCoordinateArrayFilter uniqueCoordinateArrayFilter = new UniqueCoordinateArrayFilter();
        geometry.apply(uniqueCoordinateArrayFilter);
        return uniqueCoordinateArrayFilter.getCoordinates();
    }

    private Stack grahamScan(Coordinate[] object) {
        Stack<Coordinate> stack = new Stack<Coordinate>();
        Coordinate coordinate = stack.push(object[0]);
        coordinate = stack.push(object[1]);
        coordinate = stack.push(object[2]);
        int n = 3;
        while (true) {
            if (n >= ((Coordinate[])object).length) {
                object = stack.push(object[0]);
                return stack;
            }
            coordinate = (Coordinate)stack.pop();
            while (!stack.empty() && CGAlgorithms.computeOrientation((Coordinate)stack.peek(), coordinate, object[n]) > 0) {
                coordinate = (Coordinate)stack.pop();
            }
            coordinate = stack.push(coordinate);
            coordinate = stack.push(object[n]);
            ++n;
        }
    }

    private boolean isBetween(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3) != 0) {
            return false;
        }
        if (coordinate.x != coordinate3.x) {
            if (coordinate.x <= coordinate2.x && coordinate2.x <= coordinate3.x) {
                return true;
            }
            if (coordinate3.x <= coordinate2.x && coordinate2.x <= coordinate.x) {
                return true;
            }
        }
        if (coordinate.y != coordinate3.y) {
            if (coordinate.y <= coordinate2.y && coordinate2.y <= coordinate3.y) {
                return true;
            }
            if (coordinate3.y <= coordinate2.y && coordinate2.y <= coordinate.y) {
                return true;
            }
        }
        return false;
    }

    private Geometry lineOrPolygon(Coordinate[] object) {
        if (((Coordinate[])(object = this.cleanRing((Coordinate[])object))).length == 3) {
            return this.geomFactory.createLineString(new Coordinate[]{object[0], object[1]});
        }
        object = this.geomFactory.createLinearRing((Coordinate[])object);
        return this.geomFactory.createPolygon((LinearRing)object, null);
    }

    private Coordinate[] padArray3(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = new Coordinate[3];
        int n = 0;
        while (n < 3) {
            coordinateArray2[n] = n < coordinateArray.length ? coordinateArray[n] : coordinateArray[0];
            ++n;
        }
        return coordinateArray2;
    }

    private Coordinate[] preSort(Coordinate[] coordinateArray) {
        int n = 1;
        while (true) {
            if (n >= coordinateArray.length) {
                Arrays.sort(coordinateArray, 1, coordinateArray.length, new RadialComparator(coordinateArray[0]));
                return coordinateArray;
            }
            if (coordinateArray[n].y < coordinateArray[0].y || coordinateArray[n].y == coordinateArray[0].y && coordinateArray[n].x < coordinateArray[0].x) {
                Coordinate coordinate = coordinateArray[0];
                coordinateArray[0] = coordinateArray[n];
                coordinateArray[n] = coordinate;
            }
            ++n;
        }
    }

    private Coordinate[] reduce(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = this.computeOctRing(coordinateArray);
        if (coordinateArray2 == null) {
            return coordinateArray;
        }
        Coordinate[] coordinateArray3 = new TreeSet();
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n2 >= coordinateArray2.length) {
                n2 = n;
                while (true) {
                    if (n2 >= coordinateArray.length) {
                        coordinateArray3 = CoordinateArrays.toCoordinateArray(coordinateArray3);
                        coordinateArray = coordinateArray3;
                        if (coordinateArray3.length < 3) {
                            coordinateArray = this.padArray3(coordinateArray3);
                        }
                        return coordinateArray;
                    }
                    if (!CGAlgorithms.isPointInRing(coordinateArray[n2], coordinateArray2)) {
                        coordinateArray3.add(coordinateArray[n2]);
                    }
                    ++n2;
                }
            }
            coordinateArray3.add(coordinateArray2[n2]);
            ++n2;
        }
    }

    public Geometry getConvexHull() {
        Coordinate[] coordinateArray = this.inputPts;
        if (coordinateArray.length == 0) {
            return this.geomFactory.createGeometryCollection(null);
        }
        if (coordinateArray.length == 1) {
            return this.geomFactory.createPoint(coordinateArray[0]);
        }
        if (coordinateArray.length == 2) {
            return this.geomFactory.createLineString(coordinateArray);
        }
        Coordinate[] coordinateArray2 = coordinateArray;
        if (coordinateArray.length > 50) {
            coordinateArray2 = this.reduce(coordinateArray);
        }
        return this.lineOrPolygon(this.toCoordinateArray(this.grahamScan(this.preSort(coordinateArray2))));
    }

    protected Coordinate[] toCoordinateArray(Stack stack) {
        Coordinate[] coordinateArray = new Coordinate[stack.size()];
        int n = 0;
        while (n < stack.size()) {
            coordinateArray[n] = (Coordinate)stack.get(n);
            ++n;
        }
        return coordinateArray;
    }

    private static class RadialComparator
    implements Comparator {
        private Coordinate origin;

        public RadialComparator(Coordinate coordinate) {
            this.origin = coordinate;
        }

        private static int polarCompare(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
            double d = coordinate2.x - coordinate.x;
            double d2 = coordinate2.y - coordinate.y;
            double d3 = coordinate3.x - coordinate.x;
            double d4 = coordinate3.y - coordinate.y;
            int n = CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3);
            if (n == 1) {
                return 1;
            }
            if (n == -1) {
                return -1;
            }
            if ((d2 = d * d + d2 * d2) < (d3 = d3 * d3 + d4 * d4)) {
                return -1;
            }
            if (d2 > d3) {
                return 1;
            }
            return 0;
        }

        public int compare(Object object, Object object2) {
            object = (Coordinate)object;
            object2 = (Coordinate)object2;
            return RadialComparator.polarCompare(this.origin, (Coordinate)object, (Coordinate)object2);
        }
    }
}

