/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class InteriorPointArea {
    private GeometryFactory factory;
    private Coordinate interiorPoint = null;
    private double maxWidth = 0.0;

    public InteriorPointArea(Geometry geometry) {
        this.factory = geometry.getFactory();
        this.add(geometry);
    }

    private void add(Geometry geometry) {
        if (geometry instanceof Polygon) {
            this.addPolygon(geometry);
        } else if (geometry instanceof GeometryCollection) {
            geometry = (GeometryCollection)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                this.add(((GeometryCollection)geometry).getGeometryN(i));
            }
        }
    }

    private void addPolygon(Geometry comparable) {
        if (((Geometry)comparable).isEmpty()) {
            return;
        }
        LineString lineString = this.horizontalBisector((Geometry)comparable);
        double d = lineString.getLength();
        double d2 = 0.0;
        if (d == 0.0) {
            comparable = lineString.getCoordinate();
        } else {
            comparable = this.widestGeometry(lineString.intersection((Geometry)comparable));
            d2 = ((Geometry)comparable).getEnvelopeInternal().getWidth();
            comparable = InteriorPointArea.centre(((Geometry)comparable).getEnvelopeInternal());
        }
        if (this.interiorPoint == null || d2 > this.maxWidth) {
            this.interiorPoint = comparable;
            this.maxWidth = d2;
        }
    }

    private static double avg(double d, double d2) {
        return (d + d2) / 2.0;
    }

    public static Coordinate centre(Envelope envelope) {
        return new Coordinate(InteriorPointArea.avg(envelope.getMinX(), envelope.getMaxX()), InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY()));
    }

    private Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    private Geometry widestGeometry(GeometryCollection geometryCollection) {
        if (geometryCollection.isEmpty()) {
            return geometryCollection;
        }
        Geometry geometry = geometryCollection.getGeometryN(0);
        int n = 1;
        while (n < geometryCollection.getNumGeometries()) {
            Geometry geometry2 = geometry;
            if (geometryCollection.getGeometryN(n).getEnvelopeInternal().getWidth() > geometry.getEnvelopeInternal().getWidth()) {
                geometry2 = geometryCollection.getGeometryN(n);
            }
            ++n;
            geometry = geometry2;
        }
        return geometry;
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    protected LineString horizontalBisector(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        double d = SafeBisectorFinder.getBisectorY((Polygon)geometry);
        return this.factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), d), new Coordinate(envelope.getMaxX(), d)});
    }

    private static class SafeBisectorFinder {
        private double centreY;
        private double hiY = Double.MAX_VALUE;
        private double loY = -1.7976931348623157E308;
        private Polygon poly;

        public SafeBisectorFinder(Polygon polygon) {
            double d;
            this.poly = polygon;
            this.hiY = polygon.getEnvelopeInternal().getMaxY();
            this.loY = d = polygon.getEnvelopeInternal().getMinY();
            this.centreY = InteriorPointArea.avg(d, this.hiY);
        }

        public static double getBisectorY(Polygon polygon) {
            return new SafeBisectorFinder(polygon).getBisectorY();
        }

        private void process(LineString cloneable) {
            cloneable = ((LineString)cloneable).getCoordinateSequence();
            int n = 0;
            while (n < cloneable.size()) {
                this.updateInterval(cloneable.getY(n));
                ++n;
            }
            return;
        }

        private void updateInterval(double d) {
            double d2 = this.centreY;
            if (d <= d2) {
                if (d > this.loY) {
                    this.loY = d;
                }
            } else if (d > d2 && d < this.hiY) {
                this.hiY = d;
            }
        }

        public double getBisectorY() {
            this.process(this.poly.getExteriorRing());
            int n = 0;
            while (n < this.poly.getNumInteriorRing()) {
                this.process(this.poly.getInteriorRingN(n));
                ++n;
            }
            return InteriorPointArea.avg(this.hiY, this.loY);
        }
    }
}

