/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;

public class InteriorPointPoint {
    private Coordinate centroid;
    private Coordinate interiorPoint = null;
    private double minDistance = Double.MAX_VALUE;

    public InteriorPointPoint(Geometry geometry) {
        this.centroid = geometry.getCentroid().getCoordinate();
        this.add(geometry);
    }

    private void add(Coordinate coordinate) {
        double d = coordinate.distance(this.centroid);
        if (d < this.minDistance) {
            this.interiorPoint = new Coordinate(coordinate);
            this.minDistance = d;
        }
    }

    private void add(Geometry geometry) {
        if (geometry instanceof Point) {
            this.add(geometry.getCoordinate());
        } else if (geometry instanceof GeometryCollection) {
            geometry = (GeometryCollection)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                this.add(((GeometryCollection)geometry).getGeometryN(i));
            }
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }
}

