/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.PointInRing;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.index.bintree.Bintree;
import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainBuilder;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;
import java.util.List;

public class MCPointInRing
implements PointInRing {
    private int crossings = 0;
    private Interval interval = new Interval();
    private LinearRing ring;
    private Bintree tree;

    public MCPointInRing(LinearRing linearRing) {
        this.ring = linearRing;
        this.buildIndex();
    }

    private void buildIndex() {
        this.tree = new Bintree();
        List list = MonotoneChainBuilder.getChains(CoordinateArrays.removeRepeatedPoints(this.ring.getCoordinates()));
        int n = 0;
        while (n < list.size()) {
            MonotoneChain monotoneChain = (MonotoneChain)list.get(n);
            Envelope envelope = monotoneChain.getEnvelope();
            this.interval.min = envelope.getMinY();
            this.interval.max = envelope.getMaxY();
            this.tree.insert(this.interval, monotoneChain);
            ++n;
        }
        return;
    }

    private void testLineSegment(Coordinate coordinate, LineSegment comparable) {
        Coordinate coordinate2 = comparable.p0;
        comparable = comparable.p1;
        double d = coordinate2.x;
        double d2 = coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = ((Coordinate)comparable).x;
        double d5 = coordinate.x;
        double d6 = ((Coordinate)comparable).y - coordinate.y;
        if ((d3 > 0.0 && d6 <= 0.0 || d6 > 0.0 && d3 <= 0.0) && 0.0 < (double)RobustDeterminant.signOfDet2x2(d - d2, d3, d4 - d5, d6) / (d6 - d3)) {
            ++this.crossings;
        }
    }

    private void testMonotoneChain(Envelope envelope, MCSelecter mCSelecter, MonotoneChain monotoneChain) {
        monotoneChain.select(envelope, mCSelecter);
    }

    @Override
    public boolean isInside(Coordinate object) {
        this.crossings = 0;
        Envelope envelope = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, ((Coordinate)object).y, ((Coordinate)object).y);
        this.interval.min = ((Coordinate)object).y;
        this.interval.max = ((Coordinate)object).y;
        Object object2 = this.tree.query(this.interval);
        object = new MCSelecter((Coordinate)object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            this.testMonotoneChain(envelope, (MCSelecter)object, (MonotoneChain)object2.next());
        }
        return this.crossings % 2 == 1;
    }

    class MCSelecter
    extends MonotoneChainSelectAction {
        Coordinate p;

        public MCSelecter(Coordinate coordinate) {
            this.p = coordinate;
        }

        @Override
        public void select(LineSegment lineSegment) {
            MCPointInRing.this.testLineSegment(this.p, lineSegment);
        }
    }
}

