/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

public class MinimumDiameter {
    private Coordinate[] convexHullPts = null;
    private final Geometry inputGeom;
    private final boolean isConvex;
    private LineSegment minBaseSeg = new LineSegment();
    private int minPtIndex;
    private double minWidth = 0.0;
    private Coordinate minWidthPt = null;

    public MinimumDiameter(Geometry geometry) {
        this(geometry, false);
    }

    public MinimumDiameter(Geometry geometry, boolean bl) {
        this.inputGeom = geometry;
        this.isConvex = bl;
    }

    private static double computeC(double d, double d2, Coordinate coordinate) {
        return d * coordinate.y - d2 * coordinate.x;
    }

    private void computeConvexRingMinDiameter(Coordinate[] coordinateArray) {
        this.minWidth = Double.MAX_VALUE;
        LineSegment lineSegment = new LineSegment();
        int n = 0;
        int n2 = 1;
        while (n < coordinateArray.length - 1) {
            lineSegment.p0 = coordinateArray[n];
            lineSegment.p1 = coordinateArray[++n];
            n2 = this.findMaxPerpDistance(coordinateArray, lineSegment, n2);
        }
        return;
    }

    private void computeMinimumDiameter() {
        if (this.minWidthPt != null) {
            return;
        }
        if (this.isConvex) {
            this.computeWidthConvex(this.inputGeom);
        } else {
            this.computeWidthConvex(new ConvexHull(this.inputGeom).getConvexHull());
        }
    }

    private static LineSegment computeSegmentForLine(double d, double d2, double d3) {
        Coordinate coordinate;
        Coordinate coordinate2;
        if (Math.abs(d2) > Math.abs(d)) {
            coordinate2 = new Coordinate(0.0, d3 /= d2);
            coordinate = new Coordinate(1.0, d3 - d / d2);
        } else {
            coordinate2 = new Coordinate(d3 /= d, 0.0);
            coordinate = new Coordinate(d3 - d2 / d, 1.0);
        }
        return new LineSegment(coordinate2, coordinate);
    }

    private void computeWidthConvex(Geometry coordinateArray) {
        this.convexHullPts = coordinateArray instanceof Polygon ? ((Polygon)coordinateArray).getExteriorRing().getCoordinates() : coordinateArray.getCoordinates();
        coordinateArray = this.convexHullPts;
        if (coordinateArray.length == 0) {
            this.minWidth = 0.0;
            this.minWidthPt = null;
            this.minBaseSeg = null;
        } else if (coordinateArray.length == 1) {
            this.minWidth = 0.0;
            this.minWidthPt = coordinateArray[0];
            this.minBaseSeg.p0 = coordinateArray[0];
            this.minBaseSeg.p1 = this.convexHullPts[0];
        } else if (coordinateArray.length != 2 && coordinateArray.length != 3) {
            this.computeConvexRingMinDiameter(coordinateArray);
        } else {
            this.minWidth = 0.0;
            this.minWidthPt = coordinateArray[0];
            this.minBaseSeg.p0 = coordinateArray[0];
            this.minBaseSeg.p1 = this.convexHullPts[1];
        }
    }

    private int findMaxPerpDistance(Coordinate[] coordinateArray, LineSegment lineSegment, int n) {
        double d = lineSegment.distancePerpendicular(coordinateArray[n]);
        int n2 = n;
        double d2 = d;
        while (true) {
            if (!(d2 >= d)) {
                if (d < this.minWidth) {
                    this.minPtIndex = n2;
                    this.minWidth = d;
                    this.minWidthPt = coordinateArray[n2];
                    this.minBaseSeg = new LineSegment(lineSegment);
                }
                return n2;
            }
            int n3 = MinimumDiameter.nextIndex(coordinateArray, n);
            double d3 = lineSegment.distancePerpendicular(coordinateArray[n3]);
            n2 = n;
            n = n3;
            d = d2;
            d2 = d3;
        }
    }

    public static Geometry getMinimumDiameter(Geometry geometry) {
        return new MinimumDiameter(geometry).getDiameter();
    }

    public static Geometry getMinimumRectangle(Geometry geometry) {
        return new MinimumDiameter(geometry).getMinimumRectangle();
    }

    private static int nextIndex(Coordinate[] coordinateArray, int n) {
        int n2;
        n = n2 = n + 1;
        if (n2 >= coordinateArray.length) {
            n = 0;
        }
        return n;
    }

    public LineString getDiameter() {
        this.computeMinimumDiameter();
        Coordinate coordinate = this.minWidthPt;
        if (coordinate == null) {
            return this.inputGeom.getFactory().createLineString((Coordinate[])null);
        }
        coordinate = this.minBaseSeg.project(coordinate);
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{coordinate, this.minWidthPt});
    }

    public double getLength() {
        this.computeMinimumDiameter();
        return this.minWidth;
    }

    public Geometry getMinimumRectangle() {
        double d;
        double d2;
        this.computeMinimumDiameter();
        if (this.minWidth == 0.0) {
            if (this.minBaseSeg.p0.equals2D(this.minBaseSeg.p1)) {
                return this.inputGeom.getFactory().createPoint(this.minBaseSeg.p0);
            }
            return this.minBaseSeg.toGeometry(this.inputGeom.getFactory());
        }
        double d3 = this.minBaseSeg.p1.x - this.minBaseSeg.p0.x;
        double d4 = this.minBaseSeg.p1.y - this.minBaseSeg.p0.y;
        double d5 = d2 = -1.7976931348623157E308;
        double d6 = d = Double.MAX_VALUE;
        int n = 0;
        while (true) {
            double d7;
            double d8;
            Object object;
            if (n >= ((Coordinate[])(object = this.convexHullPts)).length) {
                d8 = -d3;
                d7 = -d4;
                Comparable comparable = MinimumDiameter.computeSegmentForLine(d8, d7, d2);
                Comparable comparable2 = MinimumDiameter.computeSegmentForLine(d8, d7, d);
                LineSegment lineSegment = MinimumDiameter.computeSegmentForLine(d7, d3, d5);
                Comparable comparable3 = MinimumDiameter.computeSegmentForLine(d7, d3, d6);
                object = lineSegment.lineIntersection((LineSegment)comparable);
                comparable = comparable3.lineIntersection((LineSegment)comparable);
                comparable3 = comparable3.lineIntersection((LineSegment)comparable2);
                comparable2 = lineSegment.lineIntersection((LineSegment)comparable2);
                object = this.inputGeom.getFactory().createLinearRing(new Coordinate[]{object, comparable, comparable3, comparable2, object});
                return this.inputGeom.getFactory().createPolygon((LinearRing)object, null);
            }
            double d9 = MinimumDiameter.computeC(d3, d4, object[n]);
            d8 = d5;
            if (d9 > d5) {
                d8 = d9;
            }
            d7 = d6;
            if (d9 < d6) {
                d7 = d9;
            }
            d6 = MinimumDiameter.computeC(-d4, d3, this.convexHullPts[n]);
            d5 = d2;
            if (d6 > d2) {
                d5 = d6;
            }
            d2 = d;
            if (d6 < d) {
                d2 = d6;
            }
            ++n;
            d = d2;
            d2 = d5;
            d5 = d8;
            d6 = d7;
        }
    }

    public LineString getSupportingSegment() {
        this.computeMinimumDiameter();
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{this.minBaseSeg.p0, this.minBaseSeg.p1});
    }

    public Coordinate getWidthCoordinate() {
        this.computeMinimumDiameter();
        return this.minWidthPt;
    }
}

