/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class PointLocator {
    private BoundaryNodeRule boundaryRule = BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE;
    private boolean isIn;
    private int numBoundaries;

    public PointLocator() {
    }

    public PointLocator(BoundaryNodeRule boundaryNodeRule) {
        if (boundaryNodeRule != null) {
            this.boundaryRule = boundaryNodeRule;
            return;
        }
        throw new IllegalArgumentException("Rule must be non-null");
    }

    private void computeLocation(Coordinate coordinate, Geometry geometry) {
        block5: {
            block8: {
                int n;
                block7: {
                    block6: {
                        block4: {
                            if (geometry instanceof Point) {
                                this.updateLocationInfo(this.locate(coordinate, (Point)geometry));
                            }
                            if (!(geometry instanceof LineString)) break block4;
                            this.updateLocationInfo(this.locate(coordinate, (LineString)geometry));
                            break block5;
                        }
                        if (!(geometry instanceof Polygon)) break block6;
                        this.updateLocationInfo(this.locate(coordinate, (Polygon)geometry));
                        break block5;
                    }
                    boolean bl = geometry instanceof MultiLineString;
                    int n2 = 0;
                    if (!bl) break block7;
                    geometry = (MultiLineString)geometry;
                    for (n = 0; n < ((GeometryCollection)geometry).getNumGeometries(); ++n) {
                        this.updateLocationInfo(this.locate(coordinate, (LineString)((GeometryCollection)geometry).getGeometryN(n)));
                    }
                    break block5;
                }
                if (!(geometry instanceof MultiPolygon)) break block8;
                geometry = (MultiPolygon)geometry;
                for (n = n2; n < ((GeometryCollection)geometry).getNumGeometries(); ++n) {
                    this.updateLocationInfo(this.locate(coordinate, (Polygon)((GeometryCollection)geometry).getGeometryN(n)));
                }
                break block5;
            }
            if (!(geometry instanceof GeometryCollection)) break block5;
            GeometryCollectionIterator geometryCollectionIterator = new GeometryCollectionIterator((GeometryCollection)geometry);
            while (geometryCollectionIterator.hasNext()) {
                Geometry geometry2 = (Geometry)geometryCollectionIterator.next();
                if (geometry2 == geometry) continue;
                this.computeLocation(coordinate, geometry2);
            }
        }
    }

    private int locate(Coordinate coordinate, LineString lineString) {
        if (!lineString.getEnvelopeInternal().intersects(coordinate)) {
            return 2;
        }
        Coordinate[] coordinateArray = lineString.getCoordinates();
        if (!lineString.isClosed() && (coordinate.equals(coordinateArray[0]) || coordinate.equals(coordinateArray[coordinateArray.length - 1]))) {
            return 1;
        }
        if (CGAlgorithms.isOnLine(coordinate, coordinateArray)) {
            return 0;
        }
        return 2;
    }

    private int locate(Coordinate coordinate, Point point) {
        if (point.getCoordinate().equals2D(coordinate)) {
            return 0;
        }
        return 2;
    }

    private int locate(Coordinate coordinate, Polygon polygon) {
        if (polygon.isEmpty()) {
            return 2;
        }
        int n = this.locateInPolygonRing(coordinate, (LinearRing)polygon.getExteriorRing());
        if (n == 2) {
            return 2;
        }
        if (n == 1) {
            return 1;
        }
        n = 0;
        while (n < polygon.getNumInteriorRing()) {
            int n2 = this.locateInPolygonRing(coordinate, (LinearRing)polygon.getInteriorRingN(n));
            if (n2 == 0) {
                return 2;
            }
            if (n2 == 1) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    private int locateInPolygonRing(Coordinate coordinate, LinearRing linearRing) {
        if (!linearRing.getEnvelopeInternal().intersects(coordinate)) {
            return 2;
        }
        return CGAlgorithms.locatePointInRing(coordinate, linearRing.getCoordinates());
    }

    private void updateLocationInfo(int n) {
        if (n == 0) {
            this.isIn = true;
        }
        if (n == 1) {
            ++this.numBoundaries;
        }
    }

    public boolean intersects(Coordinate coordinate, Geometry geometry) {
        return this.locate(coordinate, geometry) != 2;
    }

    public int locate(Coordinate coordinate, Geometry geometry) {
        if (geometry.isEmpty()) {
            return 2;
        }
        if (geometry instanceof LineString) {
            return this.locate(coordinate, (LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.locate(coordinate, (Polygon)geometry);
        }
        this.isIn = false;
        this.numBoundaries = 0;
        this.computeLocation(coordinate, geometry);
        if (this.boundaryRule.isInBoundary(this.numBoundaries)) {
            return 1;
        }
        if (this.numBoundaries <= 0 && !this.isIn) {
            return 2;
        }
        return 0;
    }
}

