/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.locate;

import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.index.ArrayListVisitor;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.intervalrtree.SortedPackedIntervalRTree;
import java.util.List;

public class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private final IntervalIndexedGeometry index;

    public IndexedPointInAreaLocator(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            this.index = new IntervalIndexedGeometry(geometry);
            return;
        }
        throw new IllegalArgumentException("Argument must be Polygonal");
    }

    @Override
    public int locate(Coordinate coordinate) {
        RayCrossingCounter rayCrossingCounter = new RayCrossingCounter(coordinate);
        SegmentVisitor segmentVisitor = new SegmentVisitor(rayCrossingCounter);
        this.index.query(coordinate.y, coordinate.y, segmentVisitor);
        return rayCrossingCounter.getLocation();
    }

    private static class IntervalIndexedGeometry {
        private final SortedPackedIntervalRTree index = new SortedPackedIntervalRTree();

        public IntervalIndexedGeometry(Geometry geometry) {
            this.init(geometry);
        }

        private void addLine(Coordinate[] coordinateArray) {
            int n = 1;
            while (n < coordinateArray.length) {
                LineSegment lineSegment = new LineSegment(coordinateArray[n - 1], coordinateArray[n]);
                double d = Math.min(lineSegment.p0.y, lineSegment.p1.y);
                double d2 = Math.max(lineSegment.p0.y, lineSegment.p1.y);
                this.index.insert(d, d2, lineSegment);
                ++n;
            }
            return;
        }

        private void init(Geometry object) {
            object = LinearComponentExtracter.getLines((Geometry)object).iterator();
            while (object.hasNext()) {
                this.addLine(((LineString)object.next()).getCoordinates());
            }
            return;
        }

        public List query(double d, double d2) {
            ArrayListVisitor arrayListVisitor = new ArrayListVisitor();
            this.index.query(d, d2, arrayListVisitor);
            return arrayListVisitor.getItems();
        }

        public void query(double d, double d2, ItemVisitor itemVisitor) {
            this.index.query(d, d2, itemVisitor);
        }
    }

    private static class SegmentVisitor
    implements ItemVisitor {
        private RayCrossingCounter counter;

        public SegmentVisitor(RayCrossingCounter rayCrossingCounter) {
            this.counter = rayCrossingCounter;
        }

        @Override
        public void visitItem(Object object) {
            object = (LineSegment)object;
            this.counter.countSegment(((LineSegment)object).getCoordinate(0), ((LineSegment)object).getCoordinate(1));
        }
    }
}

