/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.locate;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

public class SimplePointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;

    public SimplePointInAreaLocator(Geometry geometry) {
        this.geom = geometry;
    }

    private static boolean containsPoint(Coordinate coordinate, Geometry geometry) {
        if (geometry instanceof Polygon) {
            return SimplePointInAreaLocator.containsPointInPolygon(coordinate, (Polygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollectionIterator geometryCollectionIterator = new GeometryCollectionIterator((GeometryCollection)geometry);
            while (geometryCollectionIterator.hasNext()) {
                Geometry geometry2 = (Geometry)geometryCollectionIterator.next();
                if (geometry2 == geometry || !SimplePointInAreaLocator.containsPoint(coordinate, geometry2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsPointInPolygon(Coordinate coordinate, Polygon polygon) {
        if (polygon.isEmpty()) {
            return false;
        }
        if (!SimplePointInAreaLocator.isPointInRing(coordinate, (LinearRing)polygon.getExteriorRing())) {
            return false;
        }
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            if (SimplePointInAreaLocator.isPointInRing(coordinate, (LinearRing)polygon.getInteriorRingN(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isPointInRing(Coordinate coordinate, LinearRing linearRing) {
        if (!linearRing.getEnvelopeInternal().intersects(coordinate)) {
            return false;
        }
        return CGAlgorithms.isPointInRing(coordinate, linearRing.getCoordinates());
    }

    public static int locate(Coordinate coordinate, Geometry geometry) {
        if (geometry.isEmpty()) {
            return 2;
        }
        if (SimplePointInAreaLocator.containsPoint(coordinate, geometry)) {
            return 0;
        }
        return 2;
    }

    @Override
    public int locate(Coordinate coordinate) {
        return SimplePointInAreaLocator.locate(coordinate, this.geom);
    }
}

