/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.match;

import com.vividsolutions.jts.algorithm.distance.DiscreteHausdorffDistance;
import com.vividsolutions.jts.algorithm.match.SimilarityMeasure;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;

public class HausdorffSimilarityMeasure
implements SimilarityMeasure {
    private static final double DENSIFY_FRACTION = 0.25;

    public static double diagonalSize(Envelope envelope) {
        if (envelope.isNull()) {
            return 0.0;
        }
        double d = envelope.getWidth();
        double d2 = envelope.getHeight();
        return Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public double measure(Geometry comparable, Geometry geometry) {
        double d = DiscreteHausdorffDistance.distance((Geometry)comparable, geometry, 0.25);
        comparable = new Envelope(((Geometry)comparable).getEnvelopeInternal());
        ((Envelope)comparable).expandToInclude(geometry.getEnvelopeInternal());
        return 1.0 - d / HausdorffSimilarityMeasure.diagonalSize((Envelope)comparable);
    }
}

