/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import com.vividsolutions.jts.awt.ShapeReader;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.ArrayList;

public class FontGlyphReader {
    private static final double FLATNESS_FACTOR = 400.0;
    public static final String FONT_MONOSPACED = "Monospaced";
    public static final String FONT_SANSERIF = "SansSerif";
    public static final String FONT_SANSSERIF = "SansSerif";
    public static final String FONT_SERIF = "Serif";

    public static Geometry read(String arrayList, Font serializable, double d, GeometryFactory geometryFactory) {
        arrayList = (ArrayList<Geometry>)((String)((Object)arrayList)).toCharArray();
        GlyphVector glyphVector = ((Font)serializable).createGlyphVector(new FontRenderContext(null, false, true), (char[])arrayList);
        arrayList = new ArrayList<Geometry>();
        int n = 0;
        block0: while (n < glyphVector.getNumGlyphs()) {
            serializable = ShapeReader.read(glyphVector.getGlyphOutline(n), d, geometryFactory);
            int n2 = 0;
            while (true) {
                if (n2 >= ((Geometry)serializable).getNumGeometries()) {
                    ++n;
                    continue block0;
                }
                arrayList.add(((Geometry)serializable).getGeometryN(n2));
                ++n2;
            }
            break;
        }
        return geometryFactory.buildGeometry(arrayList);
    }

    public static Geometry read(String string2, Font font, GeometryFactory geometryFactory) {
        return FontGlyphReader.read(string2, font, (double)font.getSize() / 400.0, geometryFactory);
    }

    public static Geometry read(String string2, String string3, int n, GeometryFactory geometryFactory) {
        return FontGlyphReader.read(string2, new Font(string3, 0, n), geometryFactory);
    }
}

