/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public interface PointShapeFactory {
    public Shape createPoint(Point2D var1);

    public static abstract class BasePointShapeFactory
    implements PointShapeFactory {
        public static final double DEFAULT_SIZE = 3.0;
        protected double size = 3.0;

        public BasePointShapeFactory() {
        }

        public BasePointShapeFactory(double d) {
            this.size = d;
        }

        @Override
        public abstract Shape createPoint(Point2D var1);
    }

    public static class Circle
    extends BasePointShapeFactory {
        public Circle() {
        }

        public Circle(double d) {
            super(d);
        }

        @Override
        public Shape createPoint(Point2D point2D) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, this.size, this.size);
            double_.x = point2D.getX() - this.size / 2.0;
            double_.y = point2D.getY() - this.size / 2.0;
            return double_;
        }
    }

    public static class Cross
    extends BasePointShapeFactory {
        public Cross() {
        }

        public Cross(double d) {
            super(d);
        }

        @Override
        public Shape createPoint(Point2D cloneable) {
            float f = (float)(((Point2D)cloneable).getX() - this.size / 2.0);
            float f2 = (float)(((Point2D)cloneable).getX() - this.size / 4.0);
            float f3 = (float)(((Point2D)cloneable).getX() + this.size / 4.0);
            float f4 = (float)(((Point2D)cloneable).getX() + this.size / 2.0);
            float f5 = (float)(((Point2D)cloneable).getY() - this.size / 2.0);
            float f6 = (float)(((Point2D)cloneable).getY() - this.size / 4.0);
            float f7 = (float)(((Point2D)cloneable).getY() + this.size / 4.0);
            float f8 = (float)(((Point2D)cloneable).getY() + this.size / 2.0);
            cloneable = new GeneralPath();
            ((Path2D.Float)cloneable).moveTo(f2, f5);
            ((Path2D.Float)cloneable).lineTo(f3, f5);
            ((Path2D.Float)cloneable).lineTo(f3, f6);
            ((Path2D.Float)cloneable).lineTo(f4, f6);
            ((Path2D.Float)cloneable).lineTo(f4, f7);
            ((Path2D.Float)cloneable).lineTo(f3, f7);
            ((Path2D.Float)cloneable).lineTo(f3, f8);
            ((Path2D.Float)cloneable).lineTo(f2, f8);
            ((Path2D.Float)cloneable).lineTo(f2, f7);
            ((Path2D.Float)cloneable).lineTo(f, f7);
            ((Path2D.Float)cloneable).lineTo(f, f6);
            ((Path2D.Float)cloneable).lineTo(f2, f6);
            ((Path2D.Float)cloneable).lineTo(f2, f5);
            return cloneable;
        }
    }

    public static class Point
    extends BasePointShapeFactory {
        public Point() {
        }

        public Point(double d) {
            super(d);
        }

        @Override
        public Shape createPoint(Point2D point2D) {
            return new Line2D.Double(point2D.getX(), point2D.getY(), point2D.getX(), point2D.getY());
        }
    }

    public static class Square
    extends BasePointShapeFactory {
        public Square() {
        }

        public Square(double d) {
            super(d);
        }

        @Override
        public Shape createPoint(Point2D point2D) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.size, this.size);
            double_.x = point2D.getX() - this.size / 2.0;
            double_.y = point2D.getY() - this.size / 2.0;
            return double_;
        }
    }

    public static class Star
    extends BasePointShapeFactory {
        public Star() {
        }

        public Star(double d) {
            super(d);
        }

        @Override
        public Shape createPoint(Point2D point2D) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)(point2D.getY() - this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() + this.size * 1.0 / 8.0), (float)(point2D.getY() - this.size * 1.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() + this.size / 2.0), (float)(point2D.getY() - this.size * 1.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() + this.size * 2.0 / 8.0), (float)(point2D.getY() + this.size * 1.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() + this.size * 3.0 / 8.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)point2D.getX(), (float)(point2D.getY() + this.size * 2.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() - this.size * 3.0 / 8.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() - this.size * 2.0 / 8.0), (float)(point2D.getY() + this.size * 1.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() - this.size / 2.0), (float)(point2D.getY() - this.size * 1.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() - this.size * 1.0 / 8.0), (float)(point2D.getY() - this.size * 1.0 / 8.0));
            generalPath.closePath();
            return generalPath;
        }
    }

    public static class Triangle
    extends BasePointShapeFactory {
        public Triangle() {
        }

        public Triangle(double d) {
            super(d);
        }

        @Override
        public Shape createPoint(Point2D point2D) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)(point2D.getY() - this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() + this.size / 2.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() - this.size / 2.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)point2D.getX(), (float)(point2D.getY() - this.size / 2.0));
            return generalPath;
        }
    }

    public static class X
    extends BasePointShapeFactory {
        public X() {
        }

        public X(double d) {
            super(d);
        }

        @Override
        public Shape createPoint(Point2D point2D) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)(point2D.getY() - this.size * 1.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() + this.size * 2.0 / 8.0), (float)(point2D.getY() - this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() + this.size / 2.0), (float)(point2D.getY() - this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() + this.size * 1.0 / 8.0), (float)point2D.getY());
            generalPath.lineTo((float)(point2D.getX() + this.size / 2.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() + this.size * 2.0 / 8.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)point2D.getX(), (float)(point2D.getY() + this.size * 1.0 / 8.0));
            generalPath.lineTo((float)(point2D.getX() - this.size * 2.0 / 8.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() - this.size / 2.0), (float)(point2D.getY() + this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() - this.size * 1.0 / 8.0), (float)point2D.getY());
            generalPath.lineTo((float)(point2D.getX() - this.size / 2.0), (float)(point2D.getY() - this.size / 2.0));
            generalPath.lineTo((float)(point2D.getX() - this.size * 2.0 / 8.0), (float)(point2D.getY() - this.size / 2.0));
            generalPath.closePath();
            return generalPath;
        }
    }
}

