/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import com.vividsolutions.jts.awt.GeometryCollectionShape;
import com.vividsolutions.jts.awt.IdentityPointTransformation;
import com.vividsolutions.jts.awt.PointShapeFactory;
import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.PolygonShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ShapeWriter {
    public static final PointShapeFactory DEFAULT_POINT_FACTORY;
    public static final PointTransformation DEFAULT_POINT_TRANSFORMATION;
    private double decimationDistance = 0.0;
    private boolean doRemoveDuplicatePoints = false;
    private PointShapeFactory pointFactory;
    private PointTransformation pointTransformer = DEFAULT_POINT_TRANSFORMATION;
    private Point2D transPoint;

    static {
        DEFAULT_POINT_TRANSFORMATION = new IdentityPointTransformation();
        DEFAULT_POINT_FACTORY = new PointShapeFactory.Square(3.0);
    }

    public ShapeWriter() {
        this.pointFactory = DEFAULT_POINT_FACTORY;
        this.transPoint = new Point2D.Double();
    }

    public ShapeWriter(PointTransformation pointTransformation) {
        this(pointTransformation, null);
    }

    public ShapeWriter(PointTransformation pointTransformation, PointShapeFactory pointShapeFactory) {
        this.pointFactory = DEFAULT_POINT_FACTORY;
        this.transPoint = new Point2D.Double();
        if (pointTransformation != null) {
            this.pointTransformer = pointTransformation;
        }
        if (pointShapeFactory != null) {
            this.pointFactory = pointShapeFactory;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void appendRing(PolygonShape var1_1, Coordinate[] var2_2) {
        var3_3 = var2_2.length - 1;
        var4_4 = NaN;
        var6_5 = null;
        var7_6 = 0;
        var8_7 = NaN;
        while (true) {
            if (var7_6 >= var3_3) {
                var1_1.endRing();
                return;
            }
            var10_8 = var6_5;
            if (!(this.decimationDistance > 0.0)) ** GOTO lbl18
            var11_9 = var6_5 != null && Math.abs(var2_2[var7_6].x - var6_5.x) < this.decimationDistance && Math.abs(var2_2[var7_6].y - var6_5.y) < this.decimationDistance;
            if (var7_6 < var3_3 && var11_9) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var12_10 = var4_4;
                    break;
                }
            } else {
                var10_8 = var2_2[var7_6];
lbl18:
                // 2 sources

                this.transformPoint(var2_2[var7_6], this.transPoint);
                var12_10 = var4_4;
                var14_11 = var8_7;
                if (this.doRemoveDuplicatePoints) {
                    var11_9 = this.transPoint.getX() == var4_4 && this.transPoint.getY() == var8_7;
                    if (var7_6 < var3_3 && var11_9) {
                        var6_5 = var10_8;
                        ** continue;
                    }
                    var12_10 = this.transPoint.getX();
                    var14_11 = this.transPoint.getY();
                }
                var1_1.addToRing(this.transPoint);
                var6_5 = var10_8;
                var8_7 = var14_11;
            }
            ++var7_6;
            var4_4 = var12_10;
        }
    }

    private Shape toShape(GeometryCollection geometryCollection) {
        GeometryCollectionShape geometryCollectionShape = new GeometryCollectionShape();
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            geometryCollectionShape.add(this.toShape(geometryCollection.getGeometryN(n)));
            ++n;
        }
        return geometryCollectionShape;
    }

    private Shape toShape(Point cloneable) {
        cloneable = this.transformPoint(cloneable.getCoordinate());
        return this.pointFactory.createPoint((Point2D)cloneable);
    }

    private Shape toShape(Polygon polygon) {
        PolygonShape polygonShape = new PolygonShape();
        this.appendRing(polygonShape, polygon.getExteriorRing().getCoordinates());
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.appendRing(polygonShape, polygon.getInteriorRingN(n).getCoordinates());
            ++n;
        }
        return polygonShape;
    }

    private GeneralPath toShape(LineString lineString) {
        GeneralPath generalPath = new GeneralPath();
        Coordinate coordinate = lineString.getCoordinateN(0);
        this.transformPoint(coordinate, this.transPoint);
        generalPath.moveTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
        double d = this.transPoint.getX();
        double d2 = this.transPoint.getY();
        int n = lineString.getNumPoints() - 1;
        int n2 = 1;
        while (true) {
            block6: {
                double d3;
                double d4;
                block7: {
                    boolean bl;
                    Coordinate coordinate2;
                    block5: {
                        if (n2 > n) {
                            return generalPath;
                        }
                        coordinate2 = lineString.getCoordinateN(n2);
                        if (!(this.decimationDistance > 0.0)) break block5;
                        bl = coordinate != null && Math.abs(coordinate2.x - coordinate.x) < this.decimationDistance && Math.abs(coordinate2.y - coordinate.y) < this.decimationDistance;
                        if (n2 < n && bl) break block6;
                        coordinate = coordinate2;
                    }
                    this.transformPoint(coordinate2, this.transPoint);
                    d4 = d;
                    d3 = d2;
                    if (!this.doRemoveDuplicatePoints) break block7;
                    bl = this.transPoint.getX() == d && this.transPoint.getY() == d2;
                    if (n2 < n && bl) break block6;
                    d4 = this.transPoint.getX();
                    d3 = this.transPoint.getY();
                }
                generalPath.lineTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
                d2 = d3;
                d = d4;
            }
            ++n2;
        }
    }

    private GeneralPath toShape(MultiLineString multiLineString) {
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        while (n < multiLineString.getNumGeometries()) {
            generalPath.append(this.toShape((LineString)multiLineString.getGeometryN(n)), false);
            ++n;
        }
        return generalPath;
    }

    private Point2D transformPoint(Coordinate coordinate) {
        return this.transformPoint(coordinate, new Point2D.Double());
    }

    private Point2D transformPoint(Coordinate coordinate, Point2D point2D) {
        this.pointTransformer.transform(coordinate, point2D);
        return point2D;
    }

    public void setDecimation(double d) {
        this.decimationDistance = d;
    }

    public void setRemoveDuplicatePoints(boolean bl) {
        this.doRemoveDuplicatePoints = bl;
    }

    public Shape toShape(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        StringBuilder stringBuilder = new StringBuilder("Unrecognized Geometry class: ");
        stringBuilder.append(geometry.getClass());
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

