/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.densify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryTransformer;

public class Densifier {
    private double distanceTolerance;
    private Geometry inputGeom;

    public Densifier(Geometry geometry) {
        this.inputGeom = geometry;
    }

    public static Geometry densify(Geometry object, double d) {
        object = new Densifier((Geometry)object);
        ((Densifier)object).setDistanceTolerance(d);
        return ((Densifier)object).getResultGeometry();
    }

    private static Coordinate[] densifyPoints(Coordinate[] coordinateArray, double d, PrecisionModel precisionModel) {
        LineSegment lineSegment = new LineSegment();
        CoordinateList coordinateList = new CoordinateList();
        int n = 0;
        block0: while (true) {
            int n2 = coordinateArray.length;
            int n3 = 1;
            if (n >= n2 - 1) {
                coordinateList.add(coordinateArray[coordinateArray.length - 1], false);
                return coordinateList.toCoordinateArray();
            }
            lineSegment.p0 = coordinateArray[n];
            n2 = n + 1;
            lineSegment.p1 = coordinateArray[n2];
            coordinateList.add(lineSegment.p0, false);
            double d2 = lineSegment.getLength();
            int n4 = (int)(d2 / d) + 1;
            n = n2;
            if (n4 <= 1) continue;
            double d3 = d2 / (double)n4;
            n = n3;
            while (true) {
                if (n >= n4) {
                    n = n2;
                    continue block0;
                }
                Coordinate coordinate = lineSegment.pointAlong((double)n * d3 / d2);
                precisionModel.makePrecise(coordinate);
                coordinateList.add(coordinate, false);
                ++n;
            }
            break;
        }
    }

    public Geometry getResultGeometry() {
        return new DensifyTransformer().transform(this.inputGeom);
    }

    public void setDistanceTolerance(double d) {
        if (!(d <= 0.0)) {
            this.distanceTolerance = d;
            return;
        }
        throw new IllegalArgumentException("Tolerance must be positive");
    }

    class DensifyTransformer
    extends GeometryTransformer {
        DensifyTransformer() {
        }

        private Geometry createValidArea(Geometry geometry) {
            return geometry.buffer(0.0);
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateArray, Geometry geometry) {
            Coordinate[] coordinateArray2;
            coordinateArray = coordinateArray2 = Densifier.densifyPoints(coordinateArray.toCoordinateArray(), Densifier.this.distanceTolerance, geometry.getPrecisionModel());
            if (geometry instanceof LineString) {
                coordinateArray = coordinateArray2;
                if (coordinateArray2.length == 1) {
                    coordinateArray = new Coordinate[]{};
                }
            }
            return this.factory.getCoordinateSequenceFactory().create(coordinateArray);
        }

        @Override
        protected Geometry transformMultiPolygon(MultiPolygon multiPolygon, Geometry geometry) {
            return this.createValidArea(super.transformMultiPolygon(multiPolygon, geometry));
        }

        @Override
        protected Geometry transformPolygon(Polygon geometry, Geometry geometry2) {
            geometry = super.transformPolygon((Polygon)geometry, geometry2);
            if (geometry2 instanceof MultiPolygon) {
                return geometry;
            }
            return this.createValidArea(geometry);
        }
    }
}

