/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.edgegraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.util.Assert;

public class HalfEdge {
    private HalfEdge next;
    private Coordinate orig;
    private HalfEdge sym;

    public HalfEdge(Coordinate coordinate) {
        this.orig = coordinate;
    }

    public static HalfEdge create(Coordinate object, Coordinate coordinate) {
        object = new HalfEdge((Coordinate)object);
        ((HalfEdge)object).init(new HalfEdge(coordinate));
        return object;
    }

    public static HalfEdge init(HalfEdge halfEdge, HalfEdge halfEdge2) {
        if (halfEdge.sym == null && halfEdge2.sym == null && halfEdge.next == null && halfEdge2.next == null) {
            halfEdge.init(halfEdge2);
            return halfEdge;
        }
        throw new IllegalStateException("Edges are already initialized");
    }

    private void insertAfter(HalfEdge halfEdge) {
        Assert.equals(this.orig, halfEdge.orig());
        HalfEdge halfEdge2 = this.oNext();
        this.sym.setNext(halfEdge);
        halfEdge.sym().setNext(halfEdge2);
    }

    private void setSym(HalfEdge halfEdge) {
        this.sym = halfEdge;
    }

    public int compareAngularDirection(HalfEdge halfEdge) {
        double d = this.deltaX();
        double d2 = this.deltaY();
        double d3 = halfEdge.deltaX();
        double d4 = halfEdge.deltaY();
        if (d == d3 && d2 == d4) {
            return 0;
        }
        if ((d2 = (double)Quadrant.quadrant(d, d2)) > (d4 = (double)Quadrant.quadrant(d3, d4))) {
            return 1;
        }
        if (d2 < d4) {
            return -1;
        }
        return CGAlgorithms.computeOrientation(halfEdge.orig, halfEdge.dest(), this.dest());
    }

    public int compareTo(Object object) {
        return this.compareAngularDirection((HalfEdge)object);
    }

    public int degree() {
        int n;
        HalfEdge halfEdge;
        int n2 = 0;
        HalfEdge halfEdge2 = this;
        do {
            n = n2 + 1;
            halfEdge = halfEdge2.oNext();
            n2 = n;
            halfEdge2 = halfEdge;
        } while (halfEdge != this);
        return n;
    }

    public double deltaX() {
        return this.sym.orig.x - this.orig.x;
    }

    public double deltaY() {
        return this.sym.orig.y - this.orig.y;
    }

    public Coordinate dest() {
        return this.sym.orig;
    }

    public boolean equals(Coordinate coordinate, Coordinate coordinate2) {
        return this.orig.equals2D(coordinate) && this.sym.orig.equals(coordinate2);
    }

    public HalfEdge find(Coordinate coordinate) {
        HalfEdge halfEdge;
        HalfEdge halfEdge2 = this;
        do {
            if (halfEdge2 == null) {
                return null;
            }
            if (halfEdge2.dest().equals2D(coordinate)) {
                return halfEdge2;
            }
            halfEdge2 = halfEdge = halfEdge2.oNext();
        } while (halfEdge != this);
        return null;
    }

    protected void init(HalfEdge halfEdge) {
        this.setSym(halfEdge);
        halfEdge.setSym(this);
        this.setNext(halfEdge);
        halfEdge.setNext(this);
    }

    public void insert(HalfEdge halfEdge) {
        HalfEdge halfEdge2;
        if (this.oNext() == this) {
            this.insertAfter(halfEdge);
            return;
        }
        int n = this.compareTo(halfEdge);
        HalfEdge halfEdge3 = this;
        while ((halfEdge2 = halfEdge3.oNext()).compareTo(halfEdge) == n && halfEdge2 != this) {
            if (halfEdge2 == this) {
                Assert.shouldNeverReachHere();
                return;
            }
            halfEdge3 = halfEdge2;
        }
        halfEdge3.insertAfter(halfEdge);
    }

    public HalfEdge next() {
        return this.next;
    }

    public HalfEdge oNext() {
        return this.sym.next;
    }

    public Coordinate orig() {
        return this.orig;
    }

    public HalfEdge prev() {
        return this.sym.next().sym;
    }

    public HalfEdge prevNode() {
        HalfEdge halfEdge;
        HalfEdge halfEdge2 = this;
        do {
            if (halfEdge2.degree() != 2) {
                return halfEdge2;
            }
            halfEdge2 = halfEdge = halfEdge2.prev();
        } while (halfEdge != this);
        return null;
    }

    public void setNext(HalfEdge halfEdge) {
        this.next = halfEdge;
    }

    public HalfEdge sym() {
        return this.sym;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("HE(");
        stringBuilder.append(this.orig.x);
        stringBuilder.append(" ");
        stringBuilder.append(this.orig.y);
        stringBuilder.append(", ");
        stringBuilder.append(this.sym.orig.x);
        stringBuilder.append(" ");
        stringBuilder.append(this.sym.orig.y);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

