/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;

class DefaultCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private Coordinate[] coordinates;

    public DefaultCoordinateSequence(int n) {
        this.coordinates = new Coordinate[n];
        int n2 = 0;
        while (n2 < n) {
            this.coordinates[n2] = new Coordinate();
            ++n2;
        }
        return;
    }

    public DefaultCoordinateSequence(CoordinateSequence coordinateSequence) {
        this.coordinates = new Coordinate[coordinateSequence.size()];
        int n = 0;
        Coordinate[] coordinateArray;
        while (n < (coordinateArray = this.coordinates).length) {
            coordinateArray[n] = coordinateSequence.getCoordinateCopy(n);
            ++n;
        }
        return;
    }

    public DefaultCoordinateSequence(Coordinate[] coordinateArray) {
        if (!Geometry.hasNullElements(coordinateArray)) {
            this.coordinates = coordinateArray;
            return;
        }
        throw new IllegalArgumentException("Null coordinate");
    }

    @Override
    public Object clone() {
        Coordinate[] coordinateArray = new Coordinate[this.size()];
        int n = 0;
        Coordinate[] coordinateArray2;
        while (n < (coordinateArray2 = this.coordinates).length) {
            coordinateArray[n] = (Coordinate)coordinateArray2[n].clone();
            ++n;
        }
        return new DefaultCoordinateSequence(coordinateArray);
    }

    @Override
    public Envelope expandEnvelope(Envelope envelope) {
        int n = 0;
        Coordinate[] coordinateArray;
        while (n < (coordinateArray = this.coordinates).length) {
            envelope.expandToInclude(coordinateArray[n]);
            ++n;
        }
        return envelope;
    }

    @Override
    public Coordinate getCoordinate(int n) {
        return this.coordinates[n];
    }

    @Override
    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.coordinates[n].x;
        coordinate.y = this.coordinates[n].y;
    }

    @Override
    public Coordinate getCoordinateCopy(int n) {
        return new Coordinate(this.coordinates[n]);
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public double getOrdinate(int n, int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return Double.NaN;
                }
                return this.coordinates[n].z;
            }
            return this.coordinates[n].y;
        }
        return this.coordinates[n].x;
    }

    @Override
    public double getX(int n) {
        return this.coordinates[n].x;
    }

    @Override
    public double getY(int n) {
        return this.coordinates[n].y;
    }

    @Override
    public void setOrdinate(int n, int n2, double d) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    this.coordinates[n].z = d;
                }
            } else {
                this.coordinates[n].y = d;
            }
        } else {
            this.coordinates[n].x = d;
        }
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public String toString() {
        Object object = this.coordinates;
        if (((Coordinate[])object).length > 0) {
            object = new StringBuffer(((Coordinate[])object).length * 17);
            ((StringBuffer)object).append('(');
            ((StringBuffer)object).append(this.coordinates[0]);
            int n = 1;
            while (true) {
                if (n >= this.coordinates.length) {
                    ((StringBuffer)object).append(')');
                    return ((StringBuffer)object).toString();
                }
                ((StringBuffer)object).append(", ");
                ((StringBuffer)object).append(this.coordinates[n]);
                ++n;
            }
        }
        return "()";
    }
}

