/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometryArray, GeometryFactory objectArray) {
        super((GeometryFactory)objectArray);
        objectArray = geometryArray;
        if (geometryArray == null) {
            objectArray = new Geometry[]{};
        }
        if (!GeometryCollection.hasNullElements(objectArray)) {
            this.geometries = objectArray;
            return;
        }
        throw new IllegalArgumentException("geometries must not contain null elements");
    }

    public GeometryCollection(Geometry[] geometryArray, PrecisionModel precisionModel, int n) {
        this(geometryArray, new GeometryFactory(precisionModel, n));
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            geometryArray[n].apply(coordinateFilter);
            ++n;
        }
        return;
    }

    @Override
    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        if (this.geometries.length == 0) {
            return;
        }
        int n = 0;
        while (true) {
            block7: {
                block6: {
                    Geometry[] geometryArray;
                    if (n >= (geometryArray = this.geometries).length) break block6;
                    geometryArray[n].apply(coordinateSequenceFilter);
                    if (!coordinateSequenceFilter.isDone()) break block7;
                }
                if (coordinateSequenceFilter.isGeometryChanged()) {
                    this.geometryChanged();
                }
                return;
            }
            ++n;
        }
    }

    @Override
    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            geometryArray[n].apply(geometryComponentFilter);
            ++n;
        }
        return;
    }

    @Override
    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            geometryArray[n].apply(geometryFilter);
            ++n;
        }
        return;
    }

    @Override
    public Object clone() {
        GeometryCollection geometryCollection = (GeometryCollection)super.clone();
        geometryCollection.geometries = new Geometry[this.geometries.length];
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            geometryCollection.geometries[n] = (Geometry)geometryArray[n].clone();
            ++n;
        }
        return geometryCollection;
    }

    @Override
    protected int compareToSameClass(Object object) {
        return this.compare(new TreeSet<Geometry>(Arrays.asList(this.geometries)), new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)object).geometries)));
    }

    @Override
    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        int n;
        object = (GeometryCollection)object;
        int n2 = this.getNumGeometries();
        int n3 = ((GeometryCollection)object).getNumGeometries();
        for (n = 0; n < n2 && n < n3; ++n) {
            int n4 = this.getGeometryN(n).compareToSameClass(((GeometryCollection)object).getGeometryN(n), coordinateSequenceComparator);
            if (n4 == 0) continue;
            return n4;
        }
        if (n < n2) {
            return 1;
        }
        if (n < n3) {
            return -1;
        }
        return 0;
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            envelope.expandToInclude(geometryArray[n].getEnvelopeInternal());
            ++n;
        }
        return envelope;
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        geometry = (GeometryCollection)geometry;
        if (this.geometries.length != ((GeometryCollection)geometry).geometries.length) {
            return false;
        }
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            if (!geometryArray[n].equalsExact(((GeometryCollection)geometry).geometries[n], d)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public double getArea() {
        double d = 0.0;
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            d += geometryArray[n].getArea();
            ++n;
        }
        return d;
    }

    @Override
    public Geometry getBoundary() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public int getBoundaryDimension() {
        int n = -1;
        int n2 = 0;
        Geometry[] geometryArray;
        while (n2 < (geometryArray = this.geometries).length) {
            n = Math.max(n, geometryArray[n2].getBoundaryDimension());
            ++n2;
        }
        return n;
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n = -1;
        int n2 = 0;
        Comparable[] comparableArray;
        block0: while (n2 < (comparableArray = this.geometries).length) {
            comparableArray = comparableArray[n2].getCoordinates();
            int n3 = 0;
            while (true) {
                if (n3 >= comparableArray.length) {
                    ++n2;
                    continue block0;
                }
                coordinateArray[++n] = comparableArray[n3];
                ++n3;
            }
            break;
        }
        return coordinateArray;
    }

    @Override
    public int getDimension() {
        int n = -1;
        int n2 = 0;
        Geometry[] geometryArray;
        while (n2 < (geometryArray = this.geometries).length) {
            n = Math.max(n, geometryArray[n2].getDimension());
            ++n2;
        }
        return n;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    @Override
    public String getGeometryType() {
        return "GeometryCollection";
    }

    @Override
    public double getLength() {
        double d = 0.0;
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            d += geometryArray[n].getLength();
            ++n;
        }
        return d;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    public int getNumPoints() {
        int n = 0;
        int n2 = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            n2 += geometryArray[n].getNumPoints();
            ++n;
        }
        return n2;
    }

    @Override
    public boolean isEmpty() {
        int n = 0;
        Geometry[] geometryArray;
        while (n < (geometryArray = this.geometries).length) {
            if (!geometryArray[n].isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public void normalize() {
        int n = 0;
        while (true) {
            Object[] objectArray;
            if (n >= (objectArray = this.geometries).length) {
                Arrays.sort(objectArray);
                return;
            }
            ((Geometry)objectArray[n]).normalize();
            ++n;
        }
    }

    @Override
    public Geometry reverse() {
        Geometry[] geometryArray = new Geometry[this.geometries.length];
        int n = 0;
        Geometry[] geometryArray2;
        while (n < (geometryArray2 = this.geometries).length) {
            geometryArray[n] = geometryArray2[n].reverse();
            ++n;
        }
        return this.getFactory().createGeometryCollection(geometryArray);
    }
}

