/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.Serializable;

public class LineSegment
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3252005833466256227L;
    public Coordinate p0;
    public Coordinate p1;

    public LineSegment() {
        this(new Coordinate(), new Coordinate());
    }

    public LineSegment(double d, double d2, double d3, double d4) {
        this(new Coordinate(d, d2), new Coordinate(d3, d4));
    }

    public LineSegment(Coordinate coordinate, Coordinate coordinate2) {
        this.p0 = coordinate;
        this.p1 = coordinate2;
    }

    public LineSegment(LineSegment lineSegment) {
        this(lineSegment.p0, lineSegment.p1);
    }

    public static Coordinate midPoint(Coordinate coordinate, Coordinate coordinate2) {
        return new Coordinate((coordinate.x + coordinate2.x) / 2.0, (coordinate.y + coordinate2.y) / 2.0);
    }

    public double angle() {
        return Math.atan2(this.p1.y - this.p0.y, this.p1.x - this.p0.x);
    }

    public Coordinate closestPoint(Coordinate coordinate) {
        double d = this.projectionFactor(coordinate);
        if (d > 0.0 && d < 1.0) {
            return this.project(coordinate);
        }
        if (this.p0.distance(coordinate) < this.p1.distance(coordinate)) {
            return this.p0;
        }
        return this.p1;
    }

    public Coordinate[] closestPoints(LineSegment comparable) {
        Coordinate[] coordinateArray = this.intersection((LineSegment)comparable);
        if (coordinateArray != null) {
            return new Coordinate[]{coordinateArray, coordinateArray};
        }
        coordinateArray = new Coordinate[2];
        Coordinate coordinate = this.closestPoint(((LineSegment)comparable).p0);
        double d = coordinate.distance(((LineSegment)comparable).p0);
        coordinateArray[0] = coordinate;
        coordinateArray[1] = ((LineSegment)comparable).p0;
        coordinate = this.closestPoint(((LineSegment)comparable).p1);
        double d2 = coordinate.distance(((LineSegment)comparable).p1);
        double d3 = d;
        if (d2 < d) {
            coordinateArray[0] = coordinate;
            coordinateArray[1] = ((LineSegment)comparable).p1;
            d3 = d2;
        }
        coordinate = ((LineSegment)comparable).closestPoint(this.p0);
        d2 = coordinate.distance(this.p0);
        d = d3;
        if (d2 < d3) {
            coordinateArray[0] = this.p0;
            coordinateArray[1] = coordinate;
            d = d2;
        }
        if (((Coordinate)(comparable = ((LineSegment)comparable).closestPoint(this.p1))).distance(this.p1) < d) {
            coordinateArray[0] = this.p1;
            coordinateArray[1] = comparable;
        }
        return coordinateArray;
    }

    public int compareTo(Object object) {
        object = (LineSegment)object;
        int n = this.p0.compareTo(((LineSegment)object).p0);
        if (n != 0) {
            return n;
        }
        return this.p1.compareTo(((LineSegment)object).p1);
    }

    public double distance(Coordinate coordinate) {
        return CGAlgorithms.distancePointLine(coordinate, this.p0, this.p1);
    }

    public double distance(LineSegment lineSegment) {
        return CGAlgorithms.distanceLineLine(this.p0, this.p1, lineSegment.p0, lineSegment.p1);
    }

    public double distancePerpendicular(Coordinate coordinate) {
        return CGAlgorithms.distancePointLinePerpendicular(coordinate, this.p0, this.p1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineSegment)) {
            return false;
        }
        object = (LineSegment)object;
        return this.p0.equals(((LineSegment)object).p0) && this.p1.equals(((LineSegment)object).p1);
    }

    public boolean equalsTopo(LineSegment lineSegment) {
        return this.p0.equals(lineSegment.p0) && this.p1.equals(lineSegment.p1) || this.p0.equals(lineSegment.p1) && this.p1.equals(lineSegment.p0);
        {
        }
    }

    public Coordinate getCoordinate(int n) {
        if (n == 0) {
            return this.p0;
        }
        return this.p1;
    }

    public double getLength() {
        return this.p0.distance(this.p1);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.p0.x) ^ Double.doubleToLongBits(this.p0.y) * 31L;
        int n = (int)l;
        int n2 = (int)(l >> 32);
        l = Double.doubleToLongBits(this.p1.x) ^ Double.doubleToLongBits(this.p1.y) * 31L;
        return n ^ n2 ^ ((int)l ^ (int)(l >> 32));
    }

    public Coordinate intersection(LineSegment lineSegment) {
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        robustLineIntersector.computeIntersection(this.p0, this.p1, lineSegment.p0, lineSegment.p1);
        if (robustLineIntersector.hasIntersection()) {
            return robustLineIntersector.getIntersection(0);
        }
        return null;
    }

    public boolean isHorizontal() {
        return this.p0.y == this.p1.y;
    }

    public boolean isVertical() {
        return this.p0.x == this.p1.x;
    }

    public Coordinate lineIntersection(LineSegment comparable) {
        try {
            comparable = HCoordinate.intersection(this.p0, this.p1, comparable.p0, comparable.p1);
            return comparable;
        }
        catch (NotRepresentableException notRepresentableException) {
            return null;
        }
    }

    public double maxX() {
        return Math.max(this.p0.x, this.p1.x);
    }

    public double maxY() {
        return Math.max(this.p0.y, this.p1.y);
    }

    public Coordinate midPoint() {
        return LineSegment.midPoint(this.p0, this.p1);
    }

    public double minX() {
        return Math.min(this.p0.x, this.p1.x);
    }

    public double minY() {
        return Math.min(this.p0.y, this.p1.y);
    }

    public void normalize() {
        if (this.p1.compareTo(this.p0) < 0) {
            this.reverse();
        }
    }

    public int orientationIndex(Coordinate coordinate) {
        return CGAlgorithms.orientationIndex(this.p0, this.p1, coordinate);
    }

    public int orientationIndex(LineSegment lineSegment) {
        int n = CGAlgorithms.orientationIndex(this.p0, this.p1, lineSegment.p0);
        int n2 = CGAlgorithms.orientationIndex(this.p0, this.p1, lineSegment.p1);
        if (n >= 0 && n2 >= 0) {
            return Math.max(n, n2);
        }
        if (n <= 0 && n2 <= 0) {
            return Math.max(n, n2);
        }
        return 0;
    }

    public Coordinate pointAlong(double d) {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.p0.x + (this.p1.x - this.p0.x) * d;
        coordinate.y = this.p0.y + d * (this.p1.y - this.p0.y);
        return coordinate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Coordinate pointAlongOffset(double d, double d2) {
        double d3 = this.p0.x;
        double d4 = this.p1.x;
        double d5 = this.p0.x;
        double d6 = this.p0.y;
        double d7 = this.p1.y;
        double d8 = this.p0.y;
        double d9 = this.p1.x - this.p0.x;
        double d10 = this.p1.y - this.p0.y;
        double d11 = Math.sqrt(d9 * d9 + d10 * d10);
        double d12 = 0.0;
        if (d2 != 0.0) {
            if (d11 <= 0.0) throw new IllegalStateException("Cannot compute offset from zero-length line segment");
            d12 = d9 * d2 / d11;
            d2 = d2 * d10 / d11;
            return new Coordinate(d3 + (d4 - d5) * d - d2, d6 + (d7 - d8) * d + d12);
        } else {
            d11 = 0.0;
            d2 = d12;
            d12 = d11;
        }
        return new Coordinate(d3 + (d4 - d5) * d - d2, d6 + (d7 - d8) * d + d12);
    }

    public Coordinate project(Coordinate coordinate) {
        if (!coordinate.equals(this.p0) && !coordinate.equals(this.p1)) {
            double d = this.projectionFactor(coordinate);
            coordinate = new Coordinate();
            coordinate.x = this.p0.x + (this.p1.x - this.p0.x) * d;
            coordinate.y = this.p0.y + d * (this.p1.y - this.p0.y);
            return coordinate;
        }
        return new Coordinate(coordinate);
    }

    public LineSegment project(LineSegment comparable) {
        double d = this.projectionFactor(comparable.p0);
        double d2 = this.projectionFactor(comparable.p1);
        double d3 = d - 1.0;
        double d4 = d3 == 0.0 ? 0 : (d3 > 0.0 ? 1 : -1);
        if (d4 >= 0 && d2 >= 1.0) {
            return null;
        }
        double d5 = d - 0.0;
        double d6 = d5 == 0.0 ? 0 : (d5 < 0.0 ? -1 : 1);
        if (d6 <= 0 && d2 <= 0.0) {
            return null;
        }
        Coordinate coordinate = this.project(comparable.p0);
        if (d6 < 0) {
            coordinate = this.p0;
        }
        if (d4 > 0) {
            coordinate = this.p1;
        }
        comparable = this.project(comparable.p1);
        if (d2 < 0.0) {
            comparable = this.p0;
        }
        if (d2 > 1.0) {
            comparable = this.p1;
        }
        return new LineSegment(coordinate, (Coordinate)comparable);
    }

    public double projectionFactor(Coordinate coordinate) {
        if (coordinate.equals(this.p0)) {
            return 0.0;
        }
        if (coordinate.equals(this.p1)) {
            return 1.0;
        }
        double d = this.p1.x - this.p0.x;
        double d2 = this.p1.y - this.p0.y;
        double d3 = d * d + d2 * d2;
        if (d3 <= 0.0) {
            return Double.NaN;
        }
        return ((coordinate.x - this.p0.x) * d + (coordinate.y - this.p0.y) * d2) / d3;
    }

    public void reverse() {
        Coordinate coordinate = this.p0;
        this.p0 = this.p1;
        this.p1 = coordinate;
    }

    public double segmentFraction(Coordinate coordinate) {
        double d;
        block3: {
            block4: {
                double d2;
                block2: {
                    d2 = this.projectionFactor(coordinate);
                    if (!(d2 < 0.0)) break block2;
                    d = 0.0;
                    break block3;
                }
                if (d2 > 1.0) break block4;
                d = d2;
                if (!Double.isNaN(d2)) break block3;
            }
            d = 1.0;
        }
        return d;
    }

    public void setCoordinates(Coordinate coordinate, Coordinate coordinate2) {
        this.p0.x = coordinate.x;
        this.p0.y = coordinate.y;
        this.p1.x = coordinate2.x;
        this.p1.y = coordinate2.y;
    }

    public void setCoordinates(LineSegment lineSegment) {
        this.setCoordinates(lineSegment.p0, lineSegment.p1);
    }

    public LineString toGeometry(GeometryFactory geometryFactory) {
        return geometryFactory.createLineString(new Coordinate[]{this.p0, this.p1});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LINESTRING( ");
        stringBuilder.append(this.p0.x);
        stringBuilder.append(" ");
        stringBuilder.append(this.p0.y);
        stringBuilder.append(", ");
        stringBuilder.append(this.p1.x);
        stringBuilder.append(" ");
        stringBuilder.append(this.p1.y);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

