/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.BoundaryOp;

public class MultiLineString
extends GeometryCollection
implements Lineal {
    private static final long serialVersionUID = 8166665132445433741L;

    public MultiLineString(LineString[] lineStringArray, GeometryFactory geometryFactory) {
        super(lineStringArray, geometryFactory);
    }

    public MultiLineString(LineString[] lineStringArray, PrecisionModel precisionModel, int n) {
        super(lineStringArray, new GeometryFactory(precisionModel, n));
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        int n = 0;
        while (n < this.geometries.length) {
            if (!((LineString)this.geometries[n]).isClosed()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        LineString[] lineStringArray = new LineString[n];
        int n2 = 0;
        while (n2 < this.geometries.length) {
            lineStringArray[n - 1 - n2] = (LineString)this.geometries[n2].reverse();
            ++n2;
        }
        return this.getFactory().createMultiLineString(lineStringArray);
    }
}

