/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;

public class MultiPolygon
extends GeometryCollection
implements Polygonal {
    private static final long serialVersionUID = -551033529766975875L;

    public MultiPolygon(Polygon[] polygonArray, GeometryFactory geometryFactory) {
        super(polygonArray, geometryFactory);
    }

    public MultiPolygon(Polygon[] polygonArray, PrecisionModel precisionModel, int n) {
        this(polygonArray, new GeometryFactory(precisionModel, n));
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        block0: while (true) {
            Object object;
            if (n >= this.geometries.length) {
                object = new LineString[arrayList.size()];
                return this.getFactory().createMultiLineString(arrayList.toArray((T[])object));
            }
            object = ((Polygon)this.geometries[n]).getBoundary();
            int n2 = 0;
            while (true) {
                if (n2 >= ((Geometry)object).getNumGeometries()) {
                    ++n;
                    continue block0;
                }
                arrayList.add(((Geometry)object).getGeometryN(n2));
                ++n2;
            }
            break;
        }
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public String getGeometryType() {
        return "MultiPolygon";
    }

    @Override
    public Geometry reverse() {
        Polygon[] polygonArray = new Polygon[this.geometries.length];
        int n = 0;
        while (n < this.geometries.length) {
            polygonArray[n] = (Polygon)this.geometries[n].reverse();
            ++n;
        }
        return this.getFactory().createMultiPolygon(polygonArray);
    }
}

