/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.util.Assert;

public class Point
extends Geometry
implements Puntal {
    private static final long serialVersionUID = 4902022702746614570L;
    private CoordinateSequence coordinates;

    public Point(Coordinate coordinateArray, PrecisionModel coordinateArray2, int n) {
        super(new GeometryFactory((PrecisionModel)coordinateArray2, n));
        CoordinateSequenceFactory coordinateSequenceFactory = this.getFactory().getCoordinateSequenceFactory();
        if (coordinateArray != null) {
            coordinateArray2 = new Coordinate[]{coordinateArray};
            coordinateArray = coordinateArray2;
        } else {
            coordinateArray = new Coordinate[]{};
        }
        this.init(coordinateSequenceFactory.create(coordinateArray));
    }

    public Point(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(geometryFactory);
        this.init(coordinateSequence);
    }

    private void init(CoordinateSequence coordinateSequence) {
        boolean bl = false;
        CoordinateSequence coordinateSequence2 = coordinateSequence;
        if (coordinateSequence == null) {
            coordinateSequence2 = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        if (coordinateSequence2.size() <= 1) {
            bl = true;
        }
        Assert.isTrue(bl);
        this.coordinates = coordinateSequence2;
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        if (this.isEmpty()) {
            return;
        }
        coordinateFilter.filter(this.getCoordinate());
    }

    @Override
    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        if (this.isEmpty()) {
            return;
        }
        coordinateSequenceFilter.filter(this.coordinates, 0);
        if (coordinateSequenceFilter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    @Override
    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    @Override
    public Object clone() {
        Point point = (Point)super.clone();
        point.coordinates = (CoordinateSequence)this.coordinates.clone();
        return point;
    }

    @Override
    protected int compareToSameClass(Object object) {
        object = (Point)object;
        return this.getCoordinate().compareTo(((Point)object).getCoordinate());
    }

    @Override
    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        object = (Point)object;
        return coordinateSequenceComparator.compare(this.coordinates, ((Point)object).coordinates);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        Envelope envelope = new Envelope();
        envelope.expandToInclude(this.coordinates.getX(0), this.coordinates.getY(0));
        return envelope;
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return true;
        }
        if (this.isEmpty() != geometry.isEmpty()) {
            return false;
        }
        return this.equal(((Point)geometry).getCoordinate(), this.getCoordinate(), d);
    }

    @Override
    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection(null);
    }

    @Override
    public int getBoundaryDimension() {
        return -1;
    }

    @Override
    public Coordinate getCoordinate() {
        Coordinate coordinate = this.coordinates.size() != 0 ? this.coordinates.getCoordinate(0) : null;
        return coordinate;
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.coordinates;
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = this.isEmpty() ? new Coordinate[]{} : new Coordinate[]{this.getCoordinate()};
        return coordinateArray;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public String getGeometryType() {
        return "Point";
    }

    @Override
    public int getNumPoints() {
        return this.isEmpty() ^ 1;
    }

    public double getX() {
        if (this.getCoordinate() != null) {
            return this.getCoordinate().x;
        }
        throw new IllegalStateException("getX called on empty Point");
    }

    public double getY() {
        if (this.getCoordinate() != null) {
            return this.getCoordinate().y;
        }
        throw new IllegalStateException("getY called on empty Point");
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.size() == 0;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public void normalize() {
    }

    @Override
    public Geometry reverse() {
        return (Geometry)this.clone();
    }
}

