/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PrecisionModel
implements Serializable,
Comparable {
    public static final Type FIXED = new Type("FIXED");
    public static final Type FLOATING = new Type("FLOATING");
    public static final Type FLOATING_SINGLE = new Type("FLOATING SINGLE");
    public static final double maximumPreciseValue = 9.007199254740992E15;
    private static final long serialVersionUID = 7777263578777803835L;
    private Type modelType;
    private double scale;

    public PrecisionModel() {
        this.modelType = FLOATING;
    }

    public PrecisionModel(double d) {
        this.modelType = FIXED;
        this.setScale(d);
    }

    public PrecisionModel(double d, double d2, double d3) {
        this.modelType = FIXED;
        this.setScale(d);
    }

    public PrecisionModel(Type type) {
        this.modelType = type;
        if (type == FIXED) {
            this.setScale(1.0);
        }
    }

    public PrecisionModel(PrecisionModel precisionModel) {
        this.modelType = precisionModel.modelType;
        this.scale = precisionModel.scale;
    }

    public static PrecisionModel mostPrecise(PrecisionModel precisionModel, PrecisionModel precisionModel2) {
        if (precisionModel.compareTo(precisionModel2) >= 0) {
            return precisionModel;
        }
        return precisionModel2;
    }

    private void setScale(double d) {
        this.scale = Math.abs(d);
    }

    public int compareTo(Object object) {
        object = (PrecisionModel)object;
        int n = this.getMaximumSignificantDigits();
        int n2 = ((PrecisionModel)object).getMaximumSignificantDigits();
        return new Integer(n).compareTo(new Integer(n2));
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrecisionModel)) {
            return false;
        }
        object = (PrecisionModel)object;
        return this.modelType == ((PrecisionModel)object).modelType && this.scale == ((PrecisionModel)object).scale;
    }

    public int getMaximumSignificantDigits() {
        Type type = this.modelType;
        Type type2 = FLOATING;
        int n = 16;
        if (type != type2) {
            if (type == FLOATING_SINGLE) {
                n = 6;
            } else if (type == FIXED) {
                n = (int)Math.ceil(Math.log(this.getScale()) / Math.log(10.0)) + 1;
            }
        }
        return n;
    }

    public double getOffsetX() {
        return 0.0;
    }

    public double getOffsetY() {
        return 0.0;
    }

    public double getScale() {
        return this.scale;
    }

    public Type getType() {
        return this.modelType;
    }

    public boolean isFloating() {
        Type type = this.modelType;
        return type == FLOATING || type == FLOATING_SINGLE;
    }

    public double makePrecise(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        Type type = this.modelType;
        if (type == FLOATING_SINGLE) {
            return (float)d;
        }
        double d2 = d;
        if (type == FIXED) {
            d2 = (double)Math.round(d * this.scale) / this.scale;
        }
        return d2;
    }

    public void makePrecise(Coordinate coordinate) {
        if (this.modelType == FLOATING) {
            return;
        }
        coordinate.x = this.makePrecise(coordinate.x);
        coordinate.y = this.makePrecise(coordinate.y);
    }

    public Coordinate toExternal(Coordinate coordinate) {
        return new Coordinate(coordinate);
    }

    public void toExternal(Coordinate coordinate, Coordinate coordinate2) {
        coordinate2.x = coordinate.x;
        coordinate2.y = coordinate.y;
    }

    public Coordinate toInternal(Coordinate coordinate) {
        coordinate = new Coordinate(coordinate);
        this.makePrecise(coordinate);
        return coordinate;
    }

    public void toInternal(Coordinate coordinate, Coordinate coordinate2) {
        if (this.isFloating()) {
            coordinate2.x = coordinate.x;
            coordinate2.y = coordinate.y;
        } else {
            coordinate2.x = this.makePrecise(coordinate.x);
            coordinate2.y = this.makePrecise(coordinate.y);
        }
        coordinate2.z = coordinate.z;
    }

    public String toString() {
        Object object = this.modelType;
        if (object == FLOATING) {
            object = "Floating";
        } else if (object == FLOATING_SINGLE) {
            object = "Floating-Single";
        } else if (object == FIXED) {
            object = new StringBuilder("Fixed (Scale=");
            ((StringBuilder)object).append(this.getScale());
            ((StringBuilder)object).append(")");
            object = ((StringBuilder)object).toString();
        } else {
            object = "UNKNOWN";
        }
        return object;
    }

    public static class Type
    implements Serializable {
        private static Map nameToTypeMap = new HashMap();
        private static final long serialVersionUID = -5528602631731589822L;
        private String name;

        public Type(String string2) {
            this.name = string2;
            nameToTypeMap.put(string2, this);
        }

        private Object readResolve() {
            return nameToTypeMap.get(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

