/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.geom.Coordinate;

public class Triangle {
    public Coordinate p0;
    public Coordinate p1;
    public Coordinate p2;

    public Triangle(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        this.p0 = coordinate;
        this.p1 = coordinate2;
        this.p2 = coordinate3;
    }

    public static Coordinate angleBisector(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.distance(coordinate);
        double d2 = d / (coordinate2.distance(coordinate3) + d);
        double d3 = coordinate3.x;
        double d4 = coordinate.x;
        d = coordinate3.y;
        double d5 = coordinate.y;
        return new Coordinate(coordinate.x + (d3 - d4) * d2, coordinate.y + d2 * (d - d5));
    }

    public static double area(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return Math.abs(((coordinate3.x - coordinate.x) * (coordinate2.y - coordinate.y) - (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate.y)) / 2.0);
    }

    public static double area3D(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        double d3 = coordinate2.z - coordinate.z;
        double d4 = coordinate3.x - coordinate.x;
        double d5 = coordinate3.y - coordinate.y;
        double d6 = coordinate3.z - coordinate.z;
        double d7 = d2 * d6 - d3 * d5;
        d6 = d3 * d4 - d6 * d;
        d4 = d * d5 - d2 * d4;
        return Math.sqrt(d7 * d7 + d6 * d6 + d4 * d4) / 2.0;
    }

    public static Coordinate centroid(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return new Coordinate((coordinate.x + coordinate2.x + coordinate3.x) / 3.0, (coordinate.y + coordinate2.y + coordinate3.y) / 3.0);
    }

    public static Coordinate circumcentre(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate3.x;
        double d2 = coordinate3.y;
        double d3 = coordinate.x - d;
        double d4 = coordinate.y - d2;
        double d5 = coordinate2.x - d;
        double d6 = coordinate2.y - d2;
        double d7 = Triangle.det(d3, d4, d5, d6) * 2.0;
        double d8 = d3 * d3 + d4 * d4;
        double d9 = d5 * d5 + d6 * d6;
        d6 = Triangle.det(d4, d8, d6, d9);
        d5 = Triangle.det(d3, d8, d5, d9);
        return new Coordinate(d - d6 / d7, d2 + d5 / d7);
    }

    private static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    public static Coordinate inCentre(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.distance(coordinate3);
        double d2 = coordinate.distance(coordinate3);
        double d3 = coordinate.distance(coordinate2);
        double d4 = d + d2 + d3;
        return new Coordinate((coordinate.x * d + coordinate2.x * d2 + coordinate3.x * d3) / d4, (d * coordinate.y + d2 * coordinate2.y + d3 * coordinate3.y) / d4);
    }

    public static double interpolateZ(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = coordinate2.x;
        double d2 = coordinate2.y;
        double d3 = coordinate3.x - d;
        double d4 = coordinate4.x - d;
        double d5 = coordinate3.y - d2;
        double d6 = coordinate4.y - d2;
        double d7 = d3 * d6 - d4 * d5;
        d = coordinate.x - d;
        d2 = coordinate.y - d2;
        d6 = (d6 * d - d4 * d2) / d7;
        d7 = (-d5 * d + d3 * d2) / d7;
        return coordinate2.z + d6 * (coordinate3.z - coordinate2.z) + d7 * (coordinate4.z - coordinate2.z);
    }

    public static boolean isAcute(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (!Angle.isAcute(coordinate, coordinate2, coordinate3)) {
            return false;
        }
        if (!Angle.isAcute(coordinate2, coordinate3, coordinate)) {
            return false;
        }
        return Angle.isAcute(coordinate3, coordinate, coordinate2);
    }

    public static double longestSideLength(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d;
        block1: {
            double d2 = coordinate.distance(coordinate2);
            double d3 = coordinate2.distance(coordinate3);
            double d4 = coordinate3.distance(coordinate);
            d = d2;
            if (d3 > d2) {
                d = d3;
            }
            if (!(d4 > d)) break block1;
            d = d4;
        }
        return d;
    }

    public static HCoordinate perpendicularBisector(Coordinate coordinate, Coordinate coordinate2) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        double d3 = coordinate.x;
        double d4 = d / 2.0;
        double d5 = coordinate.y;
        double d6 = d2 / 2.0;
        return new HCoordinate(new HCoordinate(d3 + d4, d5 + d6, 1.0), new HCoordinate(coordinate.x - d2 + d4, coordinate.y + d + d6, 1.0));
    }

    public static double signedArea(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return ((coordinate3.x - coordinate.x) * (coordinate2.y - coordinate.y) - (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate.y)) / 2.0;
    }

    public double area() {
        return Triangle.area(this.p0, this.p1, this.p2);
    }

    public double area3D() {
        return Triangle.area3D(this.p0, this.p1, this.p2);
    }

    public Coordinate centroid() {
        return Triangle.centroid(this.p0, this.p1, this.p2);
    }

    public Coordinate circumcentre() {
        return Triangle.circumcentre(this.p0, this.p1, this.p2);
    }

    public Coordinate inCentre() {
        return Triangle.inCentre(this.p0, this.p1, this.p2);
    }

    public double interpolateZ(Coordinate coordinate) {
        if (coordinate != null) {
            return Triangle.interpolateZ(coordinate, this.p0, this.p1, this.p2);
        }
        throw new IllegalArgumentException("Supplied point is null.");
    }

    public boolean isAcute() {
        return Triangle.isAcute(this.p0, this.p1, this.p2);
    }

    public double longestSideLength() {
        return Triangle.longestSideLength(this.p0, this.p1, this.p2);
    }

    public double signedArea() {
        return Triangle.signedArea(this.p0, this.p1, this.p2);
    }
}

