/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;

public class CoordinateArraySequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private Coordinate[] coordinates;
    private int dimension = 3;

    public CoordinateArraySequence(int n) {
        this.coordinates = new Coordinate[n];
        int n2 = 0;
        while (n2 < n) {
            this.coordinates[n2] = new Coordinate();
            ++n2;
        }
        return;
    }

    public CoordinateArraySequence(int n, int n2) {
        this.coordinates = new Coordinate[n];
        this.dimension = n2;
        n2 = 0;
        while (n2 < n) {
            this.coordinates[n2] = new Coordinate();
            ++n2;
        }
        return;
    }

    public CoordinateArraySequence(CoordinateSequence coordinateSequence) {
        int n = 0;
        if (coordinateSequence == null) {
            this.coordinates = new Coordinate[0];
            return;
        }
        this.dimension = coordinateSequence.getDimension();
        this.coordinates = new Coordinate[coordinateSequence.size()];
        Coordinate[] coordinateArray;
        while (n < (coordinateArray = this.coordinates).length) {
            coordinateArray[n] = coordinateSequence.getCoordinateCopy(n);
            ++n;
        }
        return;
    }

    public CoordinateArraySequence(Coordinate[] coordinateArray) {
        this(coordinateArray, 3);
    }

    public CoordinateArraySequence(Coordinate[] coordinateArray, int n) {
        this.coordinates = coordinateArray;
        this.dimension = n;
        if (coordinateArray == null) {
            this.coordinates = new Coordinate[0];
        }
    }

    @Override
    public Object clone() {
        Coordinate[] coordinateArray = new Coordinate[this.size()];
        int n = 0;
        Coordinate[] coordinateArray2;
        while (n < (coordinateArray2 = this.coordinates).length) {
            coordinateArray[n] = (Coordinate)coordinateArray2[n].clone();
            ++n;
        }
        return new CoordinateArraySequence(coordinateArray, this.dimension);
    }

    @Override
    public Envelope expandEnvelope(Envelope envelope) {
        int n = 0;
        Coordinate[] coordinateArray;
        while (n < (coordinateArray = this.coordinates).length) {
            envelope.expandToInclude(coordinateArray[n]);
            ++n;
        }
        return envelope;
    }

    @Override
    public Coordinate getCoordinate(int n) {
        return this.coordinates[n];
    }

    @Override
    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.coordinates[n].x;
        coordinate.y = this.coordinates[n].y;
        coordinate.z = this.coordinates[n].z;
    }

    @Override
    public Coordinate getCoordinateCopy(int n) {
        return new Coordinate(this.coordinates[n]);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double getOrdinate(int n, int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return Double.NaN;
                }
                return this.coordinates[n].z;
            }
            return this.coordinates[n].y;
        }
        return this.coordinates[n].x;
    }

    @Override
    public double getX(int n) {
        return this.coordinates[n].x;
    }

    @Override
    public double getY(int n) {
        return this.coordinates[n].y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setOrdinate(int n, int n2, double d) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) throw new IllegalArgumentException("invalid ordinateIndex");
                this.coordinates[n].z = d;
                return;
            } else {
                this.coordinates[n].y = d;
            }
            return;
        } else {
            this.coordinates[n].x = d;
        }
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public String toString() {
        Object object = this.coordinates;
        if (((Coordinate[])object).length > 0) {
            object = new StringBuffer(((Coordinate[])object).length * 17);
            ((StringBuffer)object).append('(');
            ((StringBuffer)object).append(this.coordinates[0]);
            int n = 1;
            while (true) {
                if (n >= this.coordinates.length) {
                    ((StringBuffer)object).append(')');
                    return ((StringBuffer)object).toString();
                }
                ((StringBuffer)object).append(", ");
                ((StringBuffer)object).append(this.coordinates[n]);
                ++n;
            }
        }
        return "()";
    }
}

