/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Envelope;
import java.lang.ref.SoftReference;

public abstract class PackedCoordinateSequence
implements CoordinateSequence {
    protected SoftReference coordRef;
    protected int dimension;

    private Coordinate[] getCachedCoords() {
        Coordinate[] coordinateArray = this.coordRef;
        if (coordinateArray != null) {
            if ((coordinateArray = (Coordinate[])coordinateArray.get()) != null) {
                return coordinateArray;
            }
            this.coordRef = null;
        }
        return null;
    }

    @Override
    public abstract Object clone();

    @Override
    public Coordinate getCoordinate(int n) {
        Coordinate[] coordinateArray = this.getCachedCoords();
        if (coordinateArray != null) {
            return coordinateArray[n];
        }
        return this.getCoordinateInternal(n);
    }

    @Override
    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.getOrdinate(n, 0);
        coordinate.y = this.getOrdinate(n, 1);
        if (this.dimension > 2) {
            coordinate.z = this.getOrdinate(n, 2);
        }
    }

    @Override
    public Coordinate getCoordinateCopy(int n) {
        return this.getCoordinateInternal(n);
    }

    protected abstract Coordinate getCoordinateInternal(int var1);

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public abstract double getOrdinate(int var1, int var2);

    @Override
    public double getX(int n) {
        return this.getOrdinate(n, 0);
    }

    @Override
    public double getY(int n) {
        return this.getOrdinate(n, 1);
    }

    @Override
    public abstract void setOrdinate(int var1, int var2, double var3);

    public void setX(int n, double d) {
        this.coordRef = null;
        this.setOrdinate(n, 0, d);
    }

    public void setY(int n, double d) {
        this.coordRef = null;
        this.setOrdinate(n, 1, d);
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        Coordinate[] coordinateArray = this.getCachedCoords();
        if (coordinateArray != null) {
            return coordinateArray;
        }
        int n = this.size();
        coordinateArray = new Coordinate[n];
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.coordRef = new SoftReference<Coordinate[]>(coordinateArray);
                return coordinateArray;
            }
            coordinateArray[n2] = this.getCoordinateInternal(n2);
            ++n2;
        }
    }

    public String toString() {
        return CoordinateSequences.toString(this);
    }

    public static class Double
    extends PackedCoordinateSequence {
        double[] coords;

        public Double(int n, int n2) {
            this.dimension = n2;
            this.coords = new double[n * this.dimension];
        }

        public Double(double[] dArray, int n) {
            if (n >= 2) {
                if (dArray.length % n == 0) {
                    this.dimension = n;
                    this.coords = dArray;
                    return;
                }
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            throw new IllegalArgumentException("Must have at least 2 dimensions");
        }

        public Double(float[] fArray, int n) {
            this.coords = new double[fArray.length];
            this.dimension = n;
            n = 0;
            while (n < fArray.length) {
                this.coords[n] = fArray[n];
                ++n;
            }
            return;
        }

        public Double(Coordinate[] coordinateArray) {
            this(coordinateArray, 3);
        }

        public Double(Coordinate[] coordinateArray, int n) {
            int n2 = 0;
            Coordinate[] coordinateArray2 = coordinateArray;
            if (coordinateArray == null) {
                coordinateArray2 = new Coordinate[]{};
            }
            this.dimension = n;
            this.coords = new double[coordinateArray2.length * this.dimension];
            n = n2;
            while (n < coordinateArray2.length) {
                this.coords[this.dimension * n] = coordinateArray2[n].x;
                if (this.dimension >= 2) {
                    this.coords[this.dimension * n + 1] = coordinateArray2[n].y;
                }
                if (this.dimension >= 3) {
                    this.coords[this.dimension * n + 2] = coordinateArray2[n].z;
                }
                ++n;
            }
            return;
        }

        @Override
        public Object clone() {
            double[] dArray = this.coords;
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return new Double(dArray2, this.dimension);
        }

        @Override
        public Envelope expandEnvelope(Envelope envelope) {
            int n = 0;
            double[] dArray;
            while (n < (dArray = this.coords).length) {
                envelope.expandToInclude(dArray[n], dArray[n + 1]);
                n += this.dimension;
            }
            return envelope;
        }

        @Override
        public Coordinate getCoordinateInternal(int n) {
            double d = this.coords[this.dimension * n];
            double d2 = this.coords[this.dimension * n + 1];
            double d3 = this.dimension == 2 ? java.lang.Double.NaN : this.coords[n * this.dimension + 2];
            return new Coordinate(d, d2, d3);
        }

        @Override
        public double getOrdinate(int n, int n2) {
            return this.coords[n * this.dimension + n2];
        }

        public double[] getRawCoordinates() {
            return this.coords;
        }

        @Override
        public void setOrdinate(int n, int n2, double d) {
            this.coordRef = null;
            this.coords[n * this.dimension + n2] = d;
        }

        @Override
        public int size() {
            return this.coords.length / this.dimension;
        }
    }

    public static class Float
    extends PackedCoordinateSequence {
        float[] coords;

        public Float(int n, int n2) {
            this.dimension = n2;
            this.coords = new float[n * this.dimension];
        }

        public Float(double[] dArray, int n) {
            this.coords = new float[dArray.length];
            this.dimension = n;
            n = 0;
            while (n < dArray.length) {
                this.coords[n] = (float)dArray[n];
                ++n;
            }
            return;
        }

        public Float(float[] fArray, int n) {
            if (n >= 2) {
                if (fArray.length % n == 0) {
                    this.dimension = n;
                    this.coords = fArray;
                    return;
                }
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            throw new IllegalArgumentException("Must have at least 2 dimensions");
        }

        public Float(Coordinate[] coordinateArray, int n) {
            int n2 = 0;
            Coordinate[] coordinateArray2 = coordinateArray;
            if (coordinateArray == null) {
                coordinateArray2 = new Coordinate[]{};
            }
            this.dimension = n;
            this.coords = new float[coordinateArray2.length * this.dimension];
            n = n2;
            while (n < coordinateArray2.length) {
                this.coords[this.dimension * n] = (float)coordinateArray2[n].x;
                if (this.dimension >= 2) {
                    this.coords[this.dimension * n + 1] = (float)coordinateArray2[n].y;
                }
                if (this.dimension >= 3) {
                    this.coords[this.dimension * n + 2] = (float)coordinateArray2[n].z;
                }
                ++n;
            }
            return;
        }

        @Override
        public Object clone() {
            float[] fArray = this.coords;
            float[] fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            return new Float(fArray2, this.dimension);
        }

        @Override
        public Envelope expandEnvelope(Envelope envelope) {
            int n = 0;
            float[] fArray;
            while (n < (fArray = this.coords).length) {
                envelope.expandToInclude(fArray[n], fArray[n + 1]);
                n += this.dimension;
            }
            return envelope;
        }

        @Override
        public Coordinate getCoordinateInternal(int n) {
            double d = this.coords[this.dimension * n];
            double d2 = this.coords[this.dimension * n + 1];
            double d3 = this.dimension == 2 ? java.lang.Double.NaN : (double)this.coords[n * this.dimension + 2];
            return new Coordinate(d, d2, d3);
        }

        @Override
        public double getOrdinate(int n, int n2) {
            return this.coords[n * this.dimension + n2];
        }

        public float[] getRawCoordinates() {
            return this.coords;
        }

        @Override
        public void setOrdinate(int n, int n2, double d) {
            this.coordRef = null;
            this.coords[n * this.dimension + n2] = (float)d;
        }

        @Override
        public int size() {
            return this.coords.length / this.dimension;
        }
    }
}

