/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;

public class PackedCoordinateSequenceFactory
implements CoordinateSequenceFactory {
    public static final int DOUBLE = 0;
    public static final PackedCoordinateSequenceFactory DOUBLE_FACTORY = new PackedCoordinateSequenceFactory(0);
    public static final int FLOAT = 1;
    public static final PackedCoordinateSequenceFactory FLOAT_FACTORY = new PackedCoordinateSequenceFactory(1);
    private int dimension = 3;
    private int type = 0;

    public PackedCoordinateSequenceFactory() {
        this(0);
    }

    public PackedCoordinateSequenceFactory(int n) {
        this(n, 3);
    }

    public PackedCoordinateSequenceFactory(int n, int n2) {
        this.setType(n);
        this.setDimension(n2);
    }

    @Override
    public CoordinateSequence create(int n, int n2) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(n, n2);
        }
        return new PackedCoordinateSequence.Float(n, n2);
    }

    @Override
    public CoordinateSequence create(CoordinateSequence coordinateSequence) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordinateSequence.toCoordinateArray(), this.dimension);
        }
        return new PackedCoordinateSequence.Float(coordinateSequence.toCoordinateArray(), this.dimension);
    }

    public CoordinateSequence create(double[] dArray, int n) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(dArray, n);
        }
        return new PackedCoordinateSequence.Float(dArray, n);
    }

    public CoordinateSequence create(float[] fArray, int n) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(fArray, n);
        }
        return new PackedCoordinateSequence.Float(fArray, n);
    }

    @Override
    public CoordinateSequence create(Coordinate[] coordinateArray) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordinateArray, this.dimension);
        }
        return new PackedCoordinateSequence.Float(coordinateArray, this.dimension);
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getType() {
        return this.type;
    }

    public void setDimension(int n) {
        this.dimension = n;
    }

    public void setType(int n) {
        if (n != 0 && n != 1) {
            StringBuilder stringBuilder = new StringBuilder("Unknown type ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.type = n;
    }
}

