/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.NoninvertibleTransformationException;
import com.vividsolutions.jts.util.Assert;

public class AffineTransformation
implements Cloneable,
CoordinateSequenceFilter {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;

    public AffineTransformation() {
        this.setToIdentity();
    }

    public AffineTransformation(double d, double d2, double d3, double d4, double d5, double d6) {
        this.setTransformation(d, d2, d3, d4, d5, d6);
    }

    public AffineTransformation(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, Coordinate coordinate5, Coordinate coordinate6) {
    }

    public AffineTransformation(AffineTransformation affineTransformation) {
        this.setTransformation(affineTransformation);
    }

    public AffineTransformation(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
    }

    public static AffineTransformation reflectionInstance(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToReflection(d, d2);
        return affineTransformation;
    }

    public static AffineTransformation reflectionInstance(double d, double d2, double d3, double d4) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToReflection(d, d2, d3, d4);
        return affineTransformation;
    }

    public static AffineTransformation rotationInstance(double d) {
        return AffineTransformation.rotationInstance(Math.sin(d), Math.cos(d));
    }

    public static AffineTransformation rotationInstance(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToRotation(d, d2);
        return affineTransformation;
    }

    public static AffineTransformation rotationInstance(double d, double d2, double d3) {
        return AffineTransformation.rotationInstance(Math.sin(d), Math.cos(d), d2, d3);
    }

    public static AffineTransformation rotationInstance(double d, double d2, double d3, double d4) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToRotation(d, d2, d3, d4);
        return affineTransformation;
    }

    public static AffineTransformation scaleInstance(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToScale(d, d2);
        return affineTransformation;
    }

    public static AffineTransformation scaleInstance(double d, double d2, double d3, double d4) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.translate(-d3, -d4);
        affineTransformation.scale(d, d2);
        affineTransformation.translate(d3, d4);
        return affineTransformation;
    }

    public static AffineTransformation shearInstance(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToShear(d, d2);
        return affineTransformation;
    }

    public static AffineTransformation translationInstance(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToTranslation(d, d2);
        return affineTransformation;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (Exception exception) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public AffineTransformation compose(AffineTransformation affineTransformation) {
        double d = affineTransformation.m00;
        double d2 = this.m00;
        double d3 = affineTransformation.m01;
        double d4 = this.m10;
        double d5 = this.m01;
        double d6 = this.m11;
        double d7 = this.m02;
        double d8 = this.m12;
        double d9 = affineTransformation.m02;
        double d10 = affineTransformation.m10;
        double d11 = affineTransformation.m11;
        double d12 = affineTransformation.m12;
        this.m00 = d * d2 + d3 * d4;
        this.m01 = d * d5 + d3 * d6;
        this.m02 = d * d7 + d3 * d8 + d9;
        this.m10 = d2 * d10 + d4 * d11;
        this.m11 = d5 * d10 + d6 * d11;
        this.m12 = d10 * d7 + d11 * d8 + d12;
        return this;
    }

    public AffineTransformation composeBefore(AffineTransformation affineTransformation) {
        double d = this.m00;
        double d2 = affineTransformation.m00;
        double d3 = this.m01;
        double d4 = affineTransformation.m10;
        double d5 = affineTransformation.m01;
        double d6 = affineTransformation.m11;
        double d7 = affineTransformation.m02;
        double d8 = affineTransformation.m12;
        double d9 = this.m02;
        double d10 = this.m10;
        double d11 = this.m11;
        double d12 = this.m12;
        this.m00 = d * d2 + d3 * d4;
        this.m01 = d * d5 + d3 * d6;
        this.m02 = d * d7 + d3 * d8 + d9;
        this.m10 = d2 * d10 + d4 * d11;
        this.m11 = d5 * d10 + d6 * d11;
        this.m12 = d10 * d7 + d11 * d8 + d12;
        return this;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AffineTransformation)) {
            return false;
        }
        object = (AffineTransformation)object;
        return this.m00 == ((AffineTransformation)object).m00 && this.m01 == ((AffineTransformation)object).m01 && this.m02 == ((AffineTransformation)object).m02 && this.m10 == ((AffineTransformation)object).m10 && this.m11 == ((AffineTransformation)object).m11 && this.m12 == ((AffineTransformation)object).m12;
    }

    @Override
    public void filter(CoordinateSequence coordinateSequence, int n) {
        this.transform(coordinateSequence, n);
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public AffineTransformation getInverse() throws NoninvertibleTransformationException {
        double d = this.getDeterminant();
        if (d != 0.0) {
            double d2 = this.m11;
            double d3 = d2 / d;
            double d4 = this.m10;
            double d5 = -d4 / d;
            double d6 = this.m01;
            double d7 = -d6 / d;
            double d8 = this.m00;
            double d9 = d8 / d;
            double d10 = this.m12;
            double d11 = this.m02;
            return new AffineTransformation(d3, d7, (d6 * d10 - d2 * d11) / d, d5, d9, (-d8 * d10 + d4 * d11) / d);
        }
        throw new NoninvertibleTransformationException("Transformation is non-invertible");
    }

    public double[] getMatrixEntries() {
        return new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isGeometryChanged() {
        return true;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    public AffineTransformation reflect(double d, double d2) {
        this.compose(AffineTransformation.reflectionInstance(d, d2));
        return this;
    }

    public AffineTransformation reflect(double d, double d2, double d3, double d4) {
        this.compose(AffineTransformation.reflectionInstance(d, d2, d3, d4));
        return this;
    }

    public AffineTransformation rotate(double d) {
        this.compose(AffineTransformation.rotationInstance(d));
        return this;
    }

    public AffineTransformation rotate(double d, double d2) {
        this.compose(AffineTransformation.rotationInstance(d, d2));
        return this;
    }

    public AffineTransformation rotate(double d, double d2, double d3) {
        this.compose(AffineTransformation.rotationInstance(d, d2, d3));
        return this;
    }

    public AffineTransformation rotate(double d, double d2, double d3, double d4) {
        this.compose(AffineTransformation.rotationInstance(d, d2));
        return this;
    }

    public AffineTransformation scale(double d, double d2) {
        this.compose(AffineTransformation.scaleInstance(d, d2));
        return this;
    }

    public AffineTransformation setToIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToReflection(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            throw new IllegalArgumentException("Reflection vector must be non-zero");
        }
        if (d == d2) {
            this.m00 = 0.0;
            this.m01 = 1.0;
            this.m02 = 0.0;
            this.m10 = 1.0;
            this.m11 = 0.0;
            this.m12 = 0.0;
            return this;
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        this.rotate(-(d2 /= d3), d /= d3);
        this.scale(1.0, -1.0);
        this.rotate(d2, d);
        return this;
    }

    public AffineTransformation setToReflection(double d, double d2, double d3, double d4) {
        if (d == d3 && d2 == d4) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        this.setToTranslation(-d, -d2);
        double d5 = d4 - d2;
        d4 = Math.sqrt((d3 -= d) * d3 + d5 * d5);
        this.rotate(-(d5 /= d4), d3 /= d4);
        this.scale(1.0, -1.0);
        this.rotate(d5, d3);
        this.translate(d, d2);
        return this;
    }

    public AffineTransformation setToReflectionBasic(double d, double d2, double d3, double d4) {
        if (d == d3 && d2 == d4) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        d = d3 - d;
        d2 = d4 - d2;
        d3 = Math.sqrt(d * d + d2 * d2);
        d2 /= d3;
        d3 = d / d3;
        d = 2.0 * d2 * d3;
        this.m00 = d2 = d3 * d3 - d2 * d2;
        this.m01 = d;
        this.m02 = 0.0;
        this.m10 = d;
        this.m11 = -d2;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToRotation(double d) {
        this.setToRotation(Math.sin(d), Math.cos(d));
        return this;
    }

    public AffineTransformation setToRotation(double d, double d2) {
        this.m00 = d2;
        this.m01 = -d;
        this.m02 = 0.0;
        this.m10 = d;
        this.m11 = d2;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToRotation(double d, double d2, double d3) {
        this.setToRotation(Math.sin(d), Math.cos(d), d2, d3);
        return this;
    }

    public AffineTransformation setToRotation(double d, double d2, double d3, double d4) {
        this.m00 = d2;
        this.m01 = -d;
        this.m02 = d3 - d3 * d2 + d4 * d;
        this.m10 = d;
        this.m11 = d2;
        this.m12 = d4 - d3 * d - d4 * d2;
        return this;
    }

    public AffineTransformation setToScale(double d, double d2) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToShear(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = d;
        this.m02 = 0.0;
        this.m10 = d2;
        this.m11 = 1.0;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToTranslation(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = d;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = d2;
        return this;
    }

    public AffineTransformation setTransformation(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        return this;
    }

    public AffineTransformation setTransformation(AffineTransformation affineTransformation) {
        this.m00 = affineTransformation.m00;
        this.m01 = affineTransformation.m01;
        this.m02 = affineTransformation.m02;
        this.m10 = affineTransformation.m10;
        this.m11 = affineTransformation.m11;
        this.m12 = affineTransformation.m12;
        return this;
    }

    public AffineTransformation shear(double d, double d2) {
        this.compose(AffineTransformation.shearInstance(d, d2));
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AffineTransformation[[");
        stringBuilder.append(this.m00);
        stringBuilder.append(", ");
        stringBuilder.append(this.m01);
        stringBuilder.append(", ");
        stringBuilder.append(this.m02);
        stringBuilder.append("], [");
        stringBuilder.append(this.m10);
        stringBuilder.append(", ");
        stringBuilder.append(this.m11);
        stringBuilder.append(", ");
        stringBuilder.append(this.m12);
        stringBuilder.append("]]");
        return stringBuilder.toString();
    }

    public Coordinate transform(Coordinate coordinate, Coordinate coordinate2) {
        double d = this.m00;
        double d2 = coordinate.x;
        double d3 = this.m01;
        double d4 = coordinate.y;
        double d5 = this.m02;
        double d6 = this.m10;
        double d7 = coordinate.x;
        double d8 = this.m11;
        double d9 = coordinate.y;
        double d10 = this.m12;
        coordinate2.x = d * d2 + d3 * d4 + d5;
        coordinate2.y = d6 * d7 + d8 * d9 + d10;
        return coordinate2;
    }

    public Geometry transform(Geometry geometry) {
        geometry = (Geometry)geometry.clone();
        geometry.apply(this);
        return geometry;
    }

    public void transform(CoordinateSequence coordinateSequence, int n) {
        double d = this.m00;
        double d2 = coordinateSequence.getOrdinate(n, 0);
        double d3 = this.m01;
        double d4 = coordinateSequence.getOrdinate(n, 1);
        double d5 = this.m02;
        double d6 = this.m10;
        double d7 = coordinateSequence.getOrdinate(n, 0);
        double d8 = this.m11;
        double d9 = coordinateSequence.getOrdinate(n, 1);
        double d10 = this.m12;
        coordinateSequence.setOrdinate(n, 0, d * d2 + d3 * d4 + d5);
        coordinateSequence.setOrdinate(n, 1, d6 * d7 + d8 * d9 + d10);
    }

    public AffineTransformation translate(double d, double d2) {
        this.compose(AffineTransformation.translationInstance(d, d2));
        return this;
    }
}

