/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.math.Matrix;

public class AffineTransformationBuilder {
    private Coordinate dest0;
    private Coordinate dest1;
    private Coordinate dest2;
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private Coordinate src0;
    private Coordinate src1;
    private Coordinate src2;

    public AffineTransformationBuilder(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, Coordinate coordinate5, Coordinate coordinate6) {
        this.src0 = coordinate;
        this.src1 = coordinate2;
        this.src2 = coordinate3;
        this.dest0 = coordinate4;
        this.dest1 = coordinate5;
        this.dest2 = coordinate6;
    }

    private boolean compute() {
        double[] dArray = this.solve(new double[]{this.dest0.x, this.dest1.x, this.dest2.x});
        if (dArray == null) {
            return false;
        }
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        dArray = this.solve(new double[]{this.dest0.y, this.dest1.y, this.dest2.y});
        if (dArray == null) {
            return false;
        }
        this.m10 = dArray[0];
        this.m11 = dArray[1];
        this.m12 = dArray[2];
        return true;
    }

    private double[] solve(double[] dArray) {
        double d = this.src0.x;
        double d2 = this.src0.y;
        double[] dArray2 = new double[]{this.src1.x, this.src1.y, 1.0};
        double d3 = this.src2.x;
        double d4 = this.src2.y;
        return Matrix.solve(new double[][]{{d, d2, 1.0}, dArray2, {d3, d4, 1.0}}, dArray);
    }

    public AffineTransformation getTransformation() {
        if (this.compute()) {
            return new AffineTransformation(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
        }
        return null;
    }
}

