/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GeometryCombiner {
    private GeometryFactory geomFactory;
    private Collection inputGeoms;
    private boolean skipEmpty = false;

    public GeometryCombiner(Collection collection) {
        this.geomFactory = GeometryCombiner.extractFactory(collection);
        this.inputGeoms = collection;
    }

    public static Geometry combine(Geometry geometry, Geometry geometry2) {
        return new GeometryCombiner(GeometryCombiner.createList(geometry, geometry2)).combine();
    }

    public static Geometry combine(Geometry geometry, Geometry geometry2, Geometry geometry3) {
        return new GeometryCombiner(GeometryCombiner.createList(geometry, geometry2, geometry3)).combine();
    }

    public static Geometry combine(Collection collection) {
        return new GeometryCombiner(collection).combine();
    }

    private static List createList(Object object, Object object2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        return arrayList;
    }

    private static List createList(Object object, Object object2, Object object3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        return arrayList;
    }

    private void extractElements(Geometry geometry, List list) {
        if (geometry == null) {
            return;
        }
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            Geometry geometry2 = geometry.getGeometryN(n);
            if (!this.skipEmpty || !geometry2.isEmpty()) {
                list.add(geometry2);
            }
            ++n;
        }
        return;
    }

    public static GeometryFactory extractFactory(Collection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return ((Geometry)collection.iterator().next()).getFactory();
    }

    public Geometry combine() {
        Serializable serializable = new ArrayList();
        Iterator iterator2 = this.inputGeoms.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                if (serializable.size() == 0) {
                    serializable = this.geomFactory;
                    if (serializable != null) {
                        return ((GeometryFactory)serializable).createGeometryCollection(null);
                    }
                    return null;
                }
                return this.geomFactory.buildGeometry((Collection)((Object)serializable));
            }
            this.extractElements((Geometry)iterator2.next(), (List)((Object)serializable));
        }
    }
}

