/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;

public class GeometryTransformer {
    protected GeometryFactory factory = null;
    private Geometry inputGeom;
    private boolean preserveCollections = false;
    private boolean preserveGeometryCollectionType = true;
    private boolean preserveType = false;
    private boolean pruneEmptyGeometry = true;

    protected final CoordinateSequence copy(CoordinateSequence coordinateSequence) {
        return (CoordinateSequence)coordinateSequence.clone();
    }

    protected final CoordinateSequence createCoordinateSequence(Coordinate[] coordinateArray) {
        return this.factory.getCoordinateSequenceFactory().create(coordinateArray);
    }

    public Geometry getInputGeometry() {
        return this.inputGeom;
    }

    public final Geometry transform(Geometry geometry) {
        this.inputGeom = geometry;
        this.factory = geometry.getFactory();
        if (geometry instanceof Point) {
            return this.transformPoint((Point)geometry, null);
        }
        if (geometry instanceof MultiPoint) {
            return this.transformMultiPoint((MultiPoint)geometry, null);
        }
        if (geometry instanceof LinearRing) {
            return this.transformLinearRing((LinearRing)geometry, null);
        }
        if (geometry instanceof LineString) {
            return this.transformLineString((LineString)geometry, null);
        }
        if (geometry instanceof MultiLineString) {
            return this.transformMultiLineString((MultiLineString)geometry, null);
        }
        if (geometry instanceof Polygon) {
            return this.transformPolygon((Polygon)geometry, null);
        }
        if (geometry instanceof MultiPolygon) {
            return this.transformMultiPolygon((MultiPolygon)geometry, null);
        }
        if (geometry instanceof GeometryCollection) {
            return this.transformGeometryCollection((GeometryCollection)geometry, null);
        }
        StringBuilder stringBuilder = new StringBuilder("Unknown Geometry subtype: ");
        stringBuilder.append(geometry.getClass().getName());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateSequence, Geometry geometry) {
        return this.copy(coordinateSequence);
    }

    protected Geometry transformGeometryCollection(GeometryCollection geometryCollection, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (true) {
            if (n >= geometryCollection.getNumGeometries()) {
                if (this.preserveGeometryCollectionType) {
                    return this.factory.createGeometryCollection(GeometryFactory.toGeometryArray(arrayList));
                }
                return this.factory.buildGeometry(arrayList);
            }
            geometry = this.transform(geometryCollection.getGeometryN(n));
            if (!(geometry == null || this.pruneEmptyGeometry && geometry.isEmpty())) {
                arrayList.add(geometry);
            }
            ++n;
        }
    }

    protected Geometry transformLineString(LineString lineString, Geometry geometry) {
        return this.factory.createLineString(this.transformCoordinates(lineString.getCoordinateSequence(), lineString));
    }

    protected Geometry transformLinearRing(LinearRing cloneable, Geometry geometry) {
        if ((cloneable = this.transformCoordinates(((LineString)cloneable).getCoordinateSequence(), (Geometry)cloneable)) == null) {
            return this.factory.createLinearRing((CoordinateSequence)null);
        }
        int n = cloneable.size();
        if (n > 0 && n < 4 && !this.preserveType) {
            return this.factory.createLineString((CoordinateSequence)cloneable);
        }
        return this.factory.createLinearRing((CoordinateSequence)cloneable);
    }

    protected Geometry transformMultiLineString(MultiLineString multiLineString, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (n < multiLineString.getNumGeometries()) {
            geometry = this.transformLineString((LineString)multiLineString.getGeometryN(n), multiLineString);
            if (geometry != null && !geometry.isEmpty()) {
                arrayList.add(geometry);
            }
            ++n;
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformMultiPoint(MultiPoint multiPoint, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (n < multiPoint.getNumGeometries()) {
            geometry = this.transformPoint((Point)multiPoint.getGeometryN(n), multiPoint);
            if (geometry != null && !geometry.isEmpty()) {
                arrayList.add(geometry);
            }
            ++n;
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformMultiPolygon(MultiPolygon multiPolygon, Geometry cloneable) {
        cloneable = new ArrayList();
        int n = 0;
        while (n < multiPolygon.getNumGeometries()) {
            Geometry geometry = this.transformPolygon((Polygon)multiPolygon.getGeometryN(n), multiPolygon);
            if (geometry != null && !geometry.isEmpty()) {
                cloneable.add(geometry);
            }
            ++n;
        }
        return this.factory.buildGeometry((Collection)((Object)cloneable));
    }

    protected Geometry transformPoint(Point point, Geometry geometry) {
        return this.factory.createPoint(this.transformCoordinates(point.getCoordinateSequence(), point));
    }

    protected Geometry transformPolygon(Polygon cloneable, Geometry geometry) {
        geometry = this.transformLinearRing((LinearRing)((Polygon)cloneable).getExteriorRing(), (Geometry)cloneable);
        boolean bl = geometry != null && geometry instanceof LinearRing && !geometry.isEmpty();
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (true) {
            if (n >= ((Polygon)cloneable).getNumInteriorRing()) {
                if (bl) {
                    return this.factory.createPolygon((LinearRing)geometry, arrayList.toArray(new LinearRing[0]));
                }
                cloneable = new ArrayList();
                if (geometry != null) {
                    cloneable.add(geometry);
                }
                cloneable.addAll(arrayList);
                return this.factory.buildGeometry((Collection)((Object)cloneable));
            }
            Geometry geometry2 = this.transformLinearRing((LinearRing)((Polygon)cloneable).getInteriorRingN(n), (Geometry)cloneable);
            boolean bl2 = bl;
            if (geometry2 != null) {
                if (geometry2.isEmpty()) {
                    bl2 = bl;
                } else {
                    if (!(geometry2 instanceof LinearRing)) {
                        bl = false;
                    }
                    arrayList.add(geometry2);
                    bl2 = bl;
                }
            }
            ++n;
            bl = bl2;
        }
    }
}

