/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinearComponentExtracter
implements GeometryComponentFilter {
    private boolean isForcedToLineString = false;
    private Collection lines;

    public LinearComponentExtracter(Collection collection) {
        this.lines = collection;
    }

    public LinearComponentExtracter(Collection collection, boolean bl) {
        this.lines = collection;
        this.isForcedToLineString = bl;
    }

    public static Geometry getGeometry(Geometry geometry) {
        return geometry.getFactory().buildGeometry(LinearComponentExtracter.getLines(geometry));
    }

    public static Geometry getGeometry(Geometry geometry, boolean bl) {
        return geometry.getFactory().buildGeometry(LinearComponentExtracter.getLines(geometry, bl));
    }

    public static Collection getLines(Geometry geometry, Collection collection) {
        if (geometry instanceof LineString) {
            collection.add(geometry);
        } else {
            geometry.apply(new LinearComponentExtracter(collection));
        }
        return collection;
    }

    public static Collection getLines(Geometry geometry, Collection collection, boolean bl) {
        geometry.apply(new LinearComponentExtracter(collection, bl));
        return collection;
    }

    public static Collection getLines(Collection object, Collection collection) {
        object = object.iterator();
        while (object.hasNext()) {
            LinearComponentExtracter.getLines((Geometry)object.next(), collection);
        }
        return collection;
    }

    public static Collection getLines(Collection object, Collection collection, boolean bl) {
        object = object.iterator();
        while (object.hasNext()) {
            LinearComponentExtracter.getLines((Geometry)object.next(), collection, bl);
        }
        return collection;
    }

    public static List getLines(Geometry geometry) {
        return LinearComponentExtracter.getLines(geometry, false);
    }

    public static List getLines(Geometry geometry, boolean bl) {
        ArrayList arrayList = new ArrayList();
        geometry.apply(new LinearComponentExtracter(arrayList, bl));
        return arrayList;
    }

    @Override
    public void filter(Geometry geometry) {
        if (this.isForcedToLineString && geometry instanceof LinearRing) {
            geometry = geometry.getFactory().createLineString(((LinearRing)geometry).getCoordinateSequence());
            this.lines.add(geometry);
            return;
        }
        if (geometry instanceof LineString) {
            this.lines.add(geometry);
        }
    }

    public void setForceToLineString(boolean bl) {
        this.isForcedToLineString = bl;
    }
}

