/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.util.GeometricShapeFactory;

public class SineStarFactory
extends GeometricShapeFactory {
    protected double armLengthRatio = 0.5;
    protected int numArms = 8;

    public SineStarFactory() {
    }

    public SineStarFactory(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    public Geometry createSineStar() {
        double d;
        Object object = this.dim.getEnvelope();
        double d2 = object.getWidth() / 2.0;
        double d3 = d = this.armLengthRatio;
        if (d < 0.0) {
            d3 = 0.0;
        }
        d = d3;
        if (d3 > 1.0) {
            d = 1.0;
        }
        d3 = (1.0 - d) * d2;
        double d4 = object.getMinX();
        double d5 = object.getMinY();
        object = new Coordinate[this.nPts + 1];
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n >= this.nPts) {
                object[n2] = new Coordinate(object[0]);
                object = this.geomFact.createLinearRing((Coordinate[])object);
                return this.geomFact.createPolygon((LinearRing)object, null);
            }
            double d6 = n;
            double d7 = d6 / (double)this.nPts * (double)this.numArms;
            d7 = (Math.cos((d7 - Math.floor(d7)) * (Math.PI * 2)) + 1.0) / 2.0 * (d * d2) + d3;
            object[n2] = this.coord(Math.cos(d6 *= Math.PI * 2 / (double)this.nPts) * d7 + (d4 + d2), d7 * Math.sin(d6) + (d5 + d2));
            ++n;
            ++n2;
        }
    }

    public void setArmLengthRatio(double d) {
        this.armLengthRatio = d;
    }

    public void setNumArms(int n) {
        this.numArms = n;
    }
}

