/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Depth;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainEdge;
import java.io.PrintStream;

public class Edge
extends GraphComponent {
    private Depth depth;
    private int depthDelta = 0;
    EdgeIntersectionList eiList = new EdgeIntersectionList(this);
    private Envelope env;
    private boolean isIsolated = true;
    private MonotoneChainEdge mce;
    private String name;
    Coordinate[] pts;

    public Edge(Coordinate[] coordinateArray) {
        this(coordinateArray, null);
    }

    public Edge(Coordinate[] coordinateArray, Label label) {
        this.depth = new Depth();
        this.pts = coordinateArray;
        this.label = label;
    }

    public static void updateIM(Label label, IntersectionMatrix intersectionMatrix) {
        intersectionMatrix.setAtLeastIfValid(label.getLocation(0, 0), label.getLocation(1, 0), 1);
        if (label.isArea()) {
            intersectionMatrix.setAtLeastIfValid(label.getLocation(0, 1), label.getLocation(1, 1), 2);
            intersectionMatrix.setAtLeastIfValid(label.getLocation(0, 2), label.getLocation(1, 2), 2);
        }
    }

    public void addIntersection(LineIntersector coordinateArray, int n, int n2, int n3) {
        Coordinate coordinate = new Coordinate(coordinateArray.getIntersection(n3));
        double d = coordinateArray.getEdgeDistance(n2, n3);
        n3 = n + 1;
        coordinateArray = this.pts;
        n2 = n;
        double d2 = d;
        if (n3 < coordinateArray.length) {
            n2 = n;
            d2 = d;
            if (coordinate.equals2D(coordinateArray[n3])) {
                d2 = 0.0;
                n2 = n3;
            }
        }
        this.eiList.add(coordinate, n2, d2);
    }

    public void addIntersections(LineIntersector lineIntersector, int n, int n2) {
        int n3 = 0;
        while (n3 < lineIntersector.getIntersectionNum()) {
            this.addIntersection(lineIntersector, n, n2, n3);
            ++n3;
        }
        return;
    }

    @Override
    public void computeIM(IntersectionMatrix intersectionMatrix) {
        Edge.updateIM(this.label, intersectionMatrix);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Edge)) {
            return false;
        }
        object = (Edge)object;
        Coordinate[] coordinateArray = this.pts;
        if (coordinateArray.length != ((Edge)object).pts.length) {
            return false;
        }
        int n = coordinateArray.length;
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = true;
        while (n2 < (coordinateArray = this.pts).length) {
            Coordinate coordinate;
            if (!coordinateArray[n2].equals2D(((Edge)object).pts[n2])) {
                bl = false;
            }
            if (!(coordinate = this.pts[n2]).equals2D((coordinateArray = ((Edge)object).pts)[--n])) {
                bl2 = false;
            }
            if (!bl && !bl2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Edge getCollapsedEdge() {
        Object object = this.pts;
        Coordinate coordinate = object[0];
        object = object[1];
        Label label = Label.toLineLabel(this.label);
        return new Edge(new Coordinate[]{coordinate, object}, label);
    }

    @Override
    public Coordinate getCoordinate() {
        Coordinate[] coordinateArray = this.pts;
        if (coordinateArray.length > 0) {
            return coordinateArray[0];
        }
        return null;
    }

    public Coordinate getCoordinate(int n) {
        return this.pts[n];
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public EdgeIntersectionList getEdgeIntersectionList() {
        return this.eiList;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            Coordinate[] coordinateArray;
            this.env = new Envelope();
            for (int i = 0; i < (coordinateArray = this.pts).length; ++i) {
                this.env.expandToInclude(coordinateArray[i]);
            }
        }
        return this.env;
    }

    public int getMaximumSegmentIndex() {
        return this.pts.length - 1;
    }

    public MonotoneChainEdge getMonotoneChainEdge() {
        if (this.mce == null) {
            this.mce = new MonotoneChainEdge(this);
        }
        return this.mce;
    }

    public int getNumPoints() {
        return this.pts.length;
    }

    public boolean isClosed() {
        Coordinate[] coordinateArray = this.pts;
        return coordinateArray[0].equals(coordinateArray[coordinateArray.length - 1]);
    }

    public boolean isCollapsed() {
        if (!this.label.isArea()) {
            return false;
        }
        Coordinate[] coordinateArray = this.pts;
        if (coordinateArray.length != 3) {
            return false;
        }
        return coordinateArray[0].equals(coordinateArray[2]);
    }

    @Override
    public boolean isIsolated() {
        return this.isIsolated;
    }

    public boolean isPointwiseEqual(Edge edge) {
        if (this.pts.length != edge.pts.length) {
            return false;
        }
        int n = 0;
        Coordinate[] coordinateArray;
        while (n < (coordinateArray = this.pts).length) {
            if (!coordinateArray[n].equals2D(edge.pts[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void print(PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder("edge ");
        stringBuilder.append(this.name);
        stringBuilder.append(": ");
        printStream.print(stringBuilder.toString());
        printStream.print("LINESTRING (");
        int n = 0;
        while (true) {
            if (n >= this.pts.length) {
                stringBuilder = new StringBuilder(")  ");
                stringBuilder.append(this.label);
                stringBuilder.append(" ");
                stringBuilder.append(this.depthDelta);
                printStream.print(stringBuilder.toString());
                return;
            }
            if (n > 0) {
                printStream.print(",");
            }
            stringBuilder = new StringBuilder(String.valueOf(this.pts[n].x));
            stringBuilder.append(" ");
            stringBuilder.append(this.pts[n].y);
            printStream.print(stringBuilder.toString());
            ++n;
        }
    }

    public void printReverse(PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder("edge ");
        stringBuilder.append(this.name);
        stringBuilder.append(": ");
        printStream.print(stringBuilder.toString());
        int n = this.pts.length - 1;
        while (true) {
            if (n < 0) {
                printStream.println("");
                return;
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append(this.pts[n]);
            stringBuilder.append(" ");
            printStream.print(stringBuilder.toString());
            --n;
        }
    }

    public void setDepthDelta(int n) {
        this.depthDelta = n;
    }

    public void setIsolated(boolean bl) {
        this.isIsolated = bl;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder = new StringBuilder("edge ");
        stringBuilder.append(this.name);
        stringBuilder.append(": ");
        stringBuffer.append(stringBuilder.toString());
        stringBuffer.append("LINESTRING (");
        int n = 0;
        while (true) {
            if (n >= this.pts.length) {
                stringBuilder = new StringBuilder(")  ");
                stringBuilder.append(this.label);
                stringBuilder.append(" ");
                stringBuilder.append(this.depthDelta);
                stringBuffer.append(stringBuilder.toString());
                return stringBuffer.toString();
            }
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuilder = new StringBuilder(String.valueOf(this.pts[n].x));
            stringBuilder.append(" ");
            stringBuilder.append(this.pts[n].y);
            stringBuffer.append(stringBuilder.toString());
            ++n;
        }
    }
}

