/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.locate.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class EdgeEndStar {
    protected List edgeList;
    protected Map edgeMap = new TreeMap();
    private int[] ptInAreaLocation = new int[]{-1, -1};

    private boolean checkAreaLabelsConsistent(int n) {
        Object object = this.getEdges();
        if (object.size() <= 0) {
            return true;
        }
        int n2 = ((EdgeEnd)object.get(object.size() - 1)).getLabel().getLocation(n, 1);
        boolean bl = n2 != -1;
        Assert.isTrue(bl, "Found unlabelled area edge");
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            object = ((EdgeEnd)iterator2.next()).getLabel();
            Assert.isTrue(((Label)object).isArea(n), "Found non-area edge");
            int n3 = ((Label)object).getLocation(n, 1);
            int n4 = ((Label)object).getLocation(n, 2);
            if (n3 == n4) {
                return false;
            }
            if (n4 != n2) {
                return false;
            }
            n2 = n3;
        }
        return true;
    }

    private void computeEdgeEndLabels(BoundaryNodeRule boundaryNodeRule) {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            ((EdgeEnd)iterator2.next()).computeLabel(boundaryNodeRule);
        }
        return;
    }

    private int getLocation(int n, Coordinate coordinate, GeometryGraph[] geometryGraphArray) {
        int[] nArray = this.ptInAreaLocation;
        if (nArray[n] == -1) {
            nArray[n] = SimplePointInAreaLocator.locate(coordinate, geometryGraphArray[n].getGeometry());
        }
        return this.ptInAreaLocation[n];
    }

    public void computeLabelling(GeometryGraph[] geometryGraphArray) {
        this.computeEdgeEndLabels(geometryGraphArray[0].getBoundaryNodeRule());
        this.propagateSideLabels(0);
        this.propagateSideLabels(1);
        boolean[] blArray = new boolean[2];
        Object object = this.iterator();
        block0: while (true) {
            int n;
            Label label;
            if (!object.hasNext()) {
                Iterator iterator2 = this.iterator();
                block1: while (true) {
                    if (!iterator2.hasNext()) {
                        return;
                    }
                    object = (EdgeEnd)iterator2.next();
                    label = ((EdgeEnd)object).getLabel();
                    n = 0;
                    while (true) {
                        if (n >= 2) continue block1;
                        if (label.isAnyNull(n)) {
                            int n2 = blArray[n] ? 2 : this.getLocation(n, ((EdgeEnd)object).getCoordinate(), geometryGraphArray);
                            label.setAllLocationsIfNull(n, n2);
                        }
                        ++n;
                    }
                    break;
                }
            }
            label = ((EdgeEnd)object.next()).getLabel();
            n = 0;
            while (true) {
                if (n >= 2) continue block0;
                if (label.isLine(n) && label.getLocation(n) == 1) {
                    blArray[n] = true;
                }
                ++n;
            }
            break;
        }
    }

    public int findIndex(EdgeEnd edgeEnd) {
        this.iterator();
        int n = 0;
        while (n < this.edgeList.size()) {
            if ((EdgeEnd)this.edgeList.get(n) == edgeEnd) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Coordinate getCoordinate() {
        Iterator iterator2 = this.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        return ((EdgeEnd)iterator2.next()).getCoordinate();
    }

    public int getDegree() {
        return this.edgeMap.size();
    }

    public List getEdges() {
        if (this.edgeList == null) {
            this.edgeList = new ArrayList(this.edgeMap.values());
        }
        return this.edgeList;
    }

    public EdgeEnd getNextCW(EdgeEnd edgeEnd) {
        this.getEdges();
        int n = this.edgeList.indexOf(edgeEnd);
        int n2 = n - 1;
        if (n == 0) {
            n2 = this.edgeList.size() - 1;
        }
        return (EdgeEnd)this.edgeList.get(n2);
    }

    public abstract void insert(EdgeEnd var1);

    protected void insertEdgeEnd(EdgeEnd edgeEnd, Object object) {
        this.edgeMap.put(edgeEnd, object);
        this.edgeList = null;
    }

    public boolean isAreaLabelsConsistent(GeometryGraph geometryGraph) {
        this.computeEdgeEndLabels(geometryGraph.getBoundaryNodeRule());
        return this.checkAreaLabelsConsistent(0);
    }

    public Iterator iterator() {
        return this.getEdges().iterator();
    }

    public void print(PrintStream printStream) {
        PrintStream printStream2 = System.out;
        Object object = new StringBuilder("EdgeEndStar:   ");
        ((StringBuilder)object).append(this.getCoordinate());
        printStream2.println(((StringBuilder)object).toString());
        object = this.iterator();
        while (object.hasNext()) {
            ((EdgeEnd)object.next()).print(printStream);
        }
        return;
    }

    void propagateSideLabels(int n) {
        Iterator iterator2 = this.iterator();
        int n2 = -1;
        while (true) {
            Object object;
            if (!iterator2.hasNext()) {
                if (n2 == -1) {
                    return;
                }
                iterator2 = this.iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        return;
                    }
                    object = (EdgeEnd)iterator2.next();
                    Object object2 = ((EdgeEnd)object).getLabel();
                    boolean bl = false;
                    if (((Label)object2).getLocation(n, 0) == -1) {
                        ((Label)object2).setLocation(n, 0, n2);
                    }
                    if (!((Label)object2).isArea(n)) continue;
                    int n3 = ((Label)object2).getLocation(n, 1);
                    int n4 = ((Label)object2).getLocation(n, 2);
                    if (n4 != -1) {
                        if (n4 == n2) {
                            if (n3 == -1) {
                                object2 = new StringBuilder("found single null side (at ");
                                ((StringBuilder)object2).append(((EdgeEnd)object).getCoordinate());
                                ((StringBuilder)object2).append(")");
                                Assert.shouldNeverReachHere(((StringBuilder)object2).toString());
                            }
                            n2 = n3;
                            continue;
                        }
                        throw new TopologyException("side location conflict", ((EdgeEnd)object).getCoordinate());
                    }
                    if (((Label)object2).getLocation(n, 1) == -1) {
                        bl = true;
                    }
                    Assert.isTrue(bl, "found single null side");
                    ((Label)object2).setLocation(n, 2, n2);
                    ((Label)object2).setLocation(n, 1, n2);
                }
            }
            object = ((EdgeEnd)iterator2.next()).getLabel();
            if (!((Label)object).isArea(n) || ((Label)object).getLocation(n, 1) == -1) continue;
            n2 = ((Label)object).getLocation(n, 1);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = new StringBuilder("EdgeEndStar:   ");
        ((StringBuilder)object).append(this.getCoordinate());
        stringBuffer.append(((StringBuilder)object).toString());
        stringBuffer.append("\n");
        object = this.iterator();
        while (object.hasNext()) {
            stringBuffer.append((EdgeEnd)object.next());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

