/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.PrintStream;

public class EdgeIntersection
implements Comparable {
    public Coordinate coord;
    public double dist;
    public int segmentIndex;

    public EdgeIntersection(Coordinate coordinate, int n, double d) {
        this.coord = new Coordinate(coordinate);
        this.segmentIndex = n;
        this.dist = d;
    }

    public int compare(int n, double d) {
        int n2 = this.segmentIndex;
        if (n2 < n) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        double d2 = this.dist;
        if (d2 < d) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        object = (EdgeIntersection)object;
        return this.compare(((EdgeIntersection)object).segmentIndex, ((EdgeIntersection)object).dist);
    }

    public Coordinate getCoordinate() {
        return this.coord;
    }

    public double getDistance() {
        return this.dist;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public boolean isEndPoint(int n) {
        int n2 = this.segmentIndex;
        if (n2 == 0 && this.dist == 0.0) {
            return true;
        }
        return n2 == n;
    }

    public void print(PrintStream printStream) {
        printStream.print(this.coord);
        StringBuilder stringBuilder = new StringBuilder(" seg # = ");
        stringBuilder.append(this.segmentIndex);
        printStream.print(stringBuilder.toString());
        stringBuilder = new StringBuilder(" dist = ");
        stringBuilder.append(this.dist);
        printStream.println(stringBuilder.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.coord);
        stringBuilder.append(" seg # = ");
        stringBuilder.append(this.segmentIndex);
        stringBuilder.append(" dist = ");
        stringBuilder.append(this.dist);
        return stringBuilder.toString();
    }
}

