/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geomgraph.TopologyLocation;

public class Label {
    TopologyLocation[] elt;

    public Label(int n) {
        TopologyLocation[] topologyLocationArray = new TopologyLocation[2];
        this.elt = topologyLocationArray;
        topologyLocationArray[0] = new TopologyLocation(n);
        this.elt[1] = new TopologyLocation(n);
    }

    public Label(int n, int n2) {
        TopologyLocation[] topologyLocationArray = new TopologyLocation[2];
        this.elt = topologyLocationArray;
        topologyLocationArray[0] = new TopologyLocation(-1);
        this.elt[1] = new TopologyLocation(-1);
        this.elt[n].setLocation(n2);
    }

    public Label(int n, int n2, int n3) {
        TopologyLocation[] topologyLocationArray = new TopologyLocation[2];
        this.elt = topologyLocationArray;
        topologyLocationArray[0] = new TopologyLocation(n, n2, n3);
        this.elt[1] = new TopologyLocation(n, n2, n3);
    }

    public Label(int n, int n2, int n3, int n4) {
        TopologyLocation[] topologyLocationArray = new TopologyLocation[2];
        this.elt = topologyLocationArray;
        topologyLocationArray[0] = new TopologyLocation(-1, -1, -1);
        this.elt[1] = new TopologyLocation(-1, -1, -1);
        this.elt[n].setLocations(n2, n3, n4);
    }

    public Label(Label label) {
        TopologyLocation[] topologyLocationArray = new TopologyLocation[2];
        this.elt = topologyLocationArray;
        topologyLocationArray[0] = new TopologyLocation(label.elt[0]);
        this.elt[1] = new TopologyLocation(label.elt[1]);
    }

    public static Label toLineLabel(Label label) {
        Label label2 = new Label(-1);
        int n = 0;
        while (n < 2) {
            label2.setLocation(n, label.getLocation(n));
            ++n;
        }
        return label2;
    }

    public boolean allPositionsEqual(int n, int n2) {
        return this.elt[n].allPositionsEqual(n2);
    }

    public void flip() {
        this.elt[0].flip();
        this.elt[1].flip();
    }

    public int getGeometryCount() {
        int n;
        int n2 = n = this.elt[0].isNull() ^ 1;
        if (!this.elt[1].isNull()) {
            n2 = n + 1;
        }
        return n2;
    }

    public int getLocation(int n) {
        return this.elt[n].get(0);
    }

    public int getLocation(int n, int n2) {
        return this.elt[n].get(n2);
    }

    public boolean isAnyNull(int n) {
        return this.elt[n].isAnyNull();
    }

    public boolean isArea() {
        return this.elt[0].isArea() || this.elt[1].isArea();
    }

    public boolean isArea(int n) {
        return this.elt[n].isArea();
    }

    public boolean isEqualOnSide(Label label, int n) {
        return this.elt[0].isEqualOnSide(label.elt[0], n) && this.elt[1].isEqualOnSide(label.elt[1], n);
    }

    public boolean isLine(int n) {
        return this.elt[n].isLine();
    }

    public boolean isNull(int n) {
        return this.elt[n].isNull();
    }

    public void merge(Label label) {
        int n = 0;
        while (n < 2) {
            TopologyLocation[] topologyLocationArray;
            TopologyLocation[] topologyLocationArray2 = this.elt;
            if (topologyLocationArray2[n] == null && (topologyLocationArray = label.elt)[n] != null) {
                topologyLocationArray2[n] = new TopologyLocation(topologyLocationArray[n]);
            } else {
                topologyLocationArray2[n].merge(label.elt[n]);
            }
            ++n;
        }
        return;
    }

    public void setAllLocations(int n, int n2) {
        this.elt[n].setAllLocations(n2);
    }

    public void setAllLocationsIfNull(int n) {
        this.setAllLocationsIfNull(0, n);
        this.setAllLocationsIfNull(1, n);
    }

    public void setAllLocationsIfNull(int n, int n2) {
        this.elt[n].setAllLocationsIfNull(n2);
    }

    public void setLocation(int n, int n2) {
        this.elt[n].setLocation(0, n2);
    }

    public void setLocation(int n, int n2, int n3) {
        this.elt[n].setLocation(n2, n3);
    }

    public void toLine(int n) {
        if (this.elt[n].isArea()) {
            TopologyLocation[] topologyLocationArray = this.elt;
            topologyLocationArray[n] = new TopologyLocation(topologyLocationArray[n].location[0]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.elt[0] != null) {
            stringBuffer.append("A:");
            stringBuffer.append(this.elt[0].toString());
        }
        if (this.elt[1] != null) {
            stringBuffer.append(" B:");
            stringBuffer.append(this.elt[1].toString());
        }
        return stringBuffer.toString();
    }
}

