/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeEndStar;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import java.io.PrintStream;
import java.util.Iterator;

public class Node
extends GraphComponent {
    protected Coordinate coord;
    protected EdgeEndStar edges;

    public Node(Coordinate coordinate, EdgeEndStar edgeEndStar) {
        this.coord = coordinate;
        this.edges = edgeEndStar;
        this.label = new Label(0, -1);
    }

    public void add(EdgeEnd edgeEnd) {
        this.edges.insert(edgeEnd);
        edgeEnd.setNode(this);
    }

    @Override
    protected void computeIM(IntersectionMatrix intersectionMatrix) {
    }

    int computeMergedLocation(Label label, int n) {
        int n2;
        int n3 = n2 = this.label.getLocation(n);
        if (!label.isNull(n)) {
            n = label.getLocation(n);
            n3 = n2;
            if (n2 != 1) {
                n3 = n;
            }
        }
        return n3;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coord;
    }

    public EdgeEndStar getEdges() {
        return this.edges;
    }

    public boolean isIncidentEdgeInResult() {
        Iterator iterator2 = this.getEdges().getEdges().iterator();
        do {
            if (iterator2.hasNext()) continue;
            return false;
        } while (!((DirectedEdge)iterator2.next()).getEdge().isInResult());
        return true;
    }

    @Override
    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    public void mergeLabel(Label label) {
        int n = 0;
        while (n < 2) {
            int n2 = this.computeMergedLocation(label, n);
            if (this.label.getLocation(n) == -1) {
                this.label.setLocation(n, n2);
            }
            ++n;
        }
        return;
    }

    public void mergeLabel(Node node) {
        this.mergeLabel(node.label);
    }

    public void print(PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder("node ");
        stringBuilder.append(this.coord);
        stringBuilder.append(" lbl: ");
        stringBuilder.append(this.label);
        printStream.println(stringBuilder.toString());
    }

    public void setLabel(int n, int n2) {
        if (this.label == null) {
            this.label = new Label(n, n2);
        } else {
            this.label.setLocation(n, n2);
        }
    }

    public void setLabelBoundary(int n) {
        int n2;
        if (this.label == null) {
            return;
        }
        int n3 = -1;
        if (this.label != null) {
            n3 = this.label.getLocation(n);
        }
        int n4 = n2 = 1;
        if (n3 != 0) {
            n4 = n3 != 1 ? n2 : 0;
        }
        this.label.setLocation(n, n4);
    }
}

