/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;

public class Quadrant {
    public static final int NE = 0;
    public static final int NW = 1;
    public static final int SE = 3;
    public static final int SW = 2;

    public static int commonHalfPlane(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if ((n - n2 + 4) % 4 == 2) {
            return -1;
        }
        int n3 = n < n2 ? n : n2;
        if (n <= n2) {
            n = n2;
        }
        if (n3 == 0 && n == 3) {
            return 3;
        }
        return n3;
    }

    public static boolean isInHalfPlane(int n, int n2) {
        if (n2 == 3) {
            return n == 3 || n == 2;
        }
        return n == n2 || n == n2 + 1;
    }

    public static boolean isNorthern(int n) {
        return n == 0 || n == 1;
    }

    public static boolean isOpposite(int n, int n2) {
        if (n == n2) {
            return false;
        }
        return (n - n2 + 4) % 4 == 2;
    }

    public static int quadrant(double d, double d2) {
        double d3 = d - 0.0;
        double d4 = d3 == 0.0 ? 0 : (d3 > 0.0 ? 1 : -1);
        if (d4 == false && d2 == 0.0) {
            StringBuilder stringBuilder = new StringBuilder("Cannot compute the quadrant for point ( ");
            stringBuilder.append(d);
            stringBuilder.append(", ");
            stringBuilder.append(d2);
            stringBuilder.append(" )");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        if (d4 >= 0) {
            if (d2 >= 0.0) {
                return 0;
            }
            return 3;
        }
        if (d2 >= 0.0) {
            return 1;
        }
        return 2;
    }

    public static int quadrant(Coordinate coordinate, Coordinate comparable) {
        if (((Coordinate)comparable).x == coordinate.x && ((Coordinate)comparable).y == coordinate.y) {
            comparable = new StringBuilder("Cannot compute the quadrant for two identical points ");
            ((StringBuilder)comparable).append(coordinate);
            throw new IllegalArgumentException(((StringBuilder)comparable).toString());
        }
        if (((Coordinate)comparable).x >= coordinate.x) {
            if (((Coordinate)comparable).y >= coordinate.y) {
                return 0;
            }
            return 3;
        }
        if (((Coordinate)comparable).y >= coordinate.y) {
            return 1;
        }
        return 2;
    }
}

