/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Location;

public class TopologyLocation {
    int[] location;

    public TopologyLocation(int n) {
        this.init(1);
        this.location[0] = n;
    }

    public TopologyLocation(int n, int n2, int n3) {
        this.init(3);
        int[] nArray = this.location;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
    }

    public TopologyLocation(TopologyLocation topologyLocation) {
        this.init(topologyLocation.location.length);
        if (topologyLocation != null) {
            int[] nArray;
            for (int i = 0; i < (nArray = this.location).length; ++i) {
                nArray[i] = topologyLocation.location[i];
            }
        }
    }

    public TopologyLocation(int[] nArray) {
        this.init(nArray.length);
    }

    private void init(int n) {
        this.location = new int[n];
        this.setAllLocations(-1);
    }

    public boolean allPositionsEqual(int n) {
        int n2 = 0;
        int[] nArray;
        while (n2 < (nArray = this.location).length) {
            if (nArray[n2] != n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void flip() {
        int[] nArray = this.location;
        if (nArray.length <= 1) {
            return;
        }
        int n = nArray[1];
        nArray[1] = nArray[2];
        nArray[2] = n;
    }

    public int get(int n) {
        int[] nArray = this.location;
        if (n < nArray.length) {
            return nArray[n];
        }
        return -1;
    }

    public int[] getLocations() {
        return this.location;
    }

    public boolean isAnyNull() {
        int n = 0;
        int[] nArray;
        while (n < (nArray = this.location).length) {
            if (nArray[n] == -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isArea() {
        return this.location.length > 1;
    }

    public boolean isEqualOnSide(TopologyLocation topologyLocation, int n) {
        return this.location[n] == topologyLocation.location[n];
    }

    public boolean isLine() {
        return this.location.length == 1;
    }

    public boolean isNull() {
        int n = 0;
        int[] nArray;
        while (n < (nArray = this.location).length) {
            if (nArray[n] != -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void merge(TopologyLocation topologyLocation) {
        int n;
        int n2 = topologyLocation.location.length;
        int[] nArray = this.location;
        int n3 = nArray.length;
        int n4 = n = 0;
        if (n2 > n3) {
            this.location = new int[]{nArray[0], -1, -1};
            n4 = n;
        }
        int[] nArray2;
        while (n4 < (nArray2 = this.location).length) {
            if (nArray2[n4] == -1 && n4 < (nArray = topologyLocation.location).length) {
                nArray2[n4] = nArray[n4];
            }
            ++n4;
        }
        return;
    }

    public void setAllLocations(int n) {
        int n2 = 0;
        int[] nArray;
        while (n2 < (nArray = this.location).length) {
            nArray[n2] = n;
            ++n2;
        }
        return;
    }

    public void setAllLocationsIfNull(int n) {
        int n2 = 0;
        int[] nArray;
        while (n2 < (nArray = this.location).length) {
            if (nArray[n2] == -1) {
                nArray[n2] = n;
            }
            ++n2;
        }
        return;
    }

    public void setLocation(int n) {
        this.setLocation(0, n);
    }

    public void setLocation(int n, int n2) {
        this.location[n] = n2;
    }

    public void setLocations(int n, int n2, int n3) {
        int[] nArray = this.location;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.location;
        if (nArray.length > 1) {
            stringBuffer.append(Location.toLocationSymbol(nArray[1]));
        }
        stringBuffer.append(Location.toLocationSymbol(this.location[0]));
        nArray = this.location;
        if (nArray.length > 1) {
            stringBuffer.append(Location.toLocationSymbol(nArray[2]));
        }
        return stringBuffer.toString();
    }
}

