/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SweepLineEvent;
import com.vividsolutions.jts.geomgraph.index.SweepLineSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SimpleSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    private void add(Edge edge, Object object) {
        Coordinate[] coordinateArray = edge.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            SweepLineSegment sweepLineSegment = new SweepLineSegment(edge, n);
            SweepLineEvent sweepLineEvent = new SweepLineEvent(object, sweepLineSegment.getMinX(), null);
            this.events.add(sweepLineEvent);
            this.events.add(new SweepLineEvent(sweepLineSegment.getMaxX(), sweepLineEvent));
            ++n;
        }
        return;
    }

    private void add(List object) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (Edge)iterator2.next();
            this.add((Edge)object, object);
        }
        return;
    }

    private void add(List object, Object object2) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((Edge)object.next(), object2);
        }
        return;
    }

    private void computeIntersections(SegmentIntersector segmentIntersector) {
        int n = 0;
        this.nOverlaps = 0;
        this.prepareEvents();
        while (n < this.events.size()) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isInsert()) {
                this.processOverlaps(n, sweepLineEvent.getDeleteEventIndex(), sweepLineEvent, segmentIntersector);
            }
            ++n;
        }
        return;
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        int n = 0;
        while (n < this.events.size()) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isDelete()) {
                sweepLineEvent.getInsertEvent().setDeleteEventIndex(n);
            }
            ++n;
        }
        return;
    }

    private void processOverlaps(int n, int n2, SweepLineEvent sweepLineEvent, SegmentIntersector segmentIntersector) {
        SweepLineSegment sweepLineSegment = (SweepLineSegment)sweepLineEvent.getObject();
        while (n < n2) {
            SweepLineEvent sweepLineEvent2 = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent2.isInsert()) {
                SweepLineSegment sweepLineSegment2 = (SweepLineSegment)sweepLineEvent2.getObject();
                if (!sweepLineEvent.isSameLabel(sweepLineEvent2)) {
                    sweepLineSegment.computeIntersections(sweepLineSegment2, segmentIntersector);
                    ++this.nOverlaps;
                }
            }
            ++n;
        }
        return;
    }

    @Override
    public void computeIntersections(List list, SegmentIntersector segmentIntersector, boolean bl) {
        if (bl) {
            this.add(list, null);
        } else {
            this.add(list);
        }
        this.computeIntersections(segmentIntersector);
    }

    @Override
    public void computeIntersections(List list, List list2, SegmentIntersector segmentIntersector) {
        this.add(list, (Object)list);
        this.add(list2, (Object)list2);
        this.computeIntersections(segmentIntersector);
    }
}

